<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/mysql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class pemasukan_penjualanPage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Input Pemasukan Penjualan');
            $this->SetMenuLabel('--> Input Pemasukan Penjualan');
    
            $this->dataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`pemasukan_penjualan`');
            $this->dataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('id_proyek'),
                    new StringField('pemasukan'),
                    new IntegerField('jumlah', true),
                    new IntegerField('bln'),
                    new DateField('tgl'),
                    new StringField('kav'),
                    new StringField('payment'),
                    new StringField('ket')
                )
            );
            $this->dataset->AddLookupField('id_proyek', 'proyek', new IntegerField('id'), new StringField('nama_proyek', false, false, false, false, 'id_proyek_nama_proyek', 'id_proyek_nama_proyek_proyek'), 'id_proyek_nama_proyek_proyek');
            $this->dataset->AddLookupField('pemasukan', 'list_pemasukan', new StringField('pemasukan'), new StringField('pemasukan', false, false, false, false, 'pemasukan_pemasukan', 'pemasukan_pemasukan_list_pemasukan'), 'pemasukan_pemasukan_list_pemasukan');
            $this->dataset->AddLookupField('kav', 'kavling', new StringField('no_kavling'), new StringField('no_kavling', false, false, false, false, 'kav_no_kavling', 'kav_no_kavling_kavling'), 'kav_no_kavling_kavling');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id', 'id', 'Id'),
                new FilterColumn($this->dataset, 'id_proyek', 'id_proyek_nama_proyek', 'Proyek'),
                new FilterColumn($this->dataset, 'pemasukan', 'pemasukan_pemasukan', 'Pemasukan'),
                new FilterColumn($this->dataset, 'jumlah', 'jumlah', 'Jumlah'),
                new FilterColumn($this->dataset, 'bln', 'bln', 'Bln'),
                new FilterColumn($this->dataset, 'tgl', 'tgl', 'Tgl'),
                new FilterColumn($this->dataset, 'kav', 'kav_no_kavling', 'Kav'),
                new FilterColumn($this->dataset, 'payment', 'payment', 'Payment'),
                new FilterColumn($this->dataset, 'ket', 'ket', 'Ket')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_proyek'])
                ->addColumn($columns['pemasukan'])
                ->addColumn($columns['jumlah'])
                ->addColumn($columns['bln'])
                ->addColumn($columns['tgl'])
                ->addColumn($columns['kav'])
                ->addColumn($columns['payment'])
                ->addColumn($columns['ket']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_proyek')
                ->setOptionsFor('pemasukan')
                ->setOptionsFor('tgl')
                ->setOptionsFor('kav');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new DynamicCombobox('id_proyek_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_pemasukan_penjualan_id_proyek_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_proyek', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_pemasukan_penjualan_id_proyek_search');
            
            $filterBuilder->addColumn(
                $columns['id_proyek'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('pemasukan_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_pemasukan_penjualan_pemasukan_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('pemasukan', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_pemasukan_penjualan_pemasukan_search');
            
            $text_editor = new TextEdit('pemasukan');
            
            $filterBuilder->addColumn(
                $columns['pemasukan'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('jumlah_edit');
            
            $filterBuilder->addColumn(
                $columns['jumlah'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new SpinEdit('bln_edit');
            
            $filterBuilder->addColumn(
                $columns['bln'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('tgl_edit', false, 'd-m-Y');
            
            $filterBuilder->addColumn(
                $columns['tgl'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('kav_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_pemasukan_penjualan_kav_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('kav', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_pemasukan_penjualan_kav_search');
            
            $text_editor = new TextEdit('kav');
            
            $filterBuilder->addColumn(
                $columns['kav'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('payment_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['payment'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ket_edit');
            $main_editor->SetMaxLength(100);
            
            $filterBuilder->addColumn(
                $columns['ket'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant()) {
            
                $operation = new AjaxOperation(OPERATION_VIEW,
                    $this->GetLocalizerCaptions()->GetMessageString('View'),
                    $this->GetLocalizerCaptions()->GetMessageString('View'), $this->dataset,
                    $this->GetModalGridViewHandler(), $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new AjaxOperation(OPERATION_EDIT,
                    $this->GetLocalizerCaptions()->GetMessageString('Edit'),
                    $this->GetLocalizerCaptions()->GetMessageString('Edit'), $this->dataset,
                    $this->GetGridEditHandler(), $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new AjaxOperation(OPERATION_COPY,
                    $this->GetLocalizerCaptions()->GetMessageString('Copy'),
                    $this->GetLocalizerCaptions()->GetMessageString('Copy'), $this->dataset,
                    $this->GetModalGridCopyHandler(), $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('id_proyek', 'id_proyek_nama_proyek', 'Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for pemasukan field
            //
            $column = new TextViewColumn('pemasukan', 'pemasukan_pemasukan', 'Pemasukan', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for jumlah field
            //
            $column = new NumberViewColumn('jumlah', 'jumlah', 'Jumlah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for bln field
            //
            $column = new NumberViewColumn('bln', 'bln', 'Bln', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for tgl field
            //
            $column = new DateTimeViewColumn('tgl', 'tgl', 'Tgl', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('d-m-Y');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_kavling field
            //
            $column = new TextViewColumn('kav', 'kav_no_kavling', 'Kav', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for payment field
            //
            $column = new TextViewColumn('payment', 'payment', 'Payment', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Ket', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('id_proyek', 'id_proyek_nama_proyek', 'Proyek', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for pemasukan field
            //
            $column = new TextViewColumn('pemasukan', 'pemasukan_pemasukan', 'Pemasukan', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for jumlah field
            //
            $column = new NumberViewColumn('jumlah', 'jumlah', 'Jumlah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for bln field
            //
            $column = new NumberViewColumn('bln', 'bln', 'Bln', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for tgl field
            //
            $column = new DateTimeViewColumn('tgl', 'tgl', 'Tgl', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('d-m-Y');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_kavling field
            //
            $column = new TextViewColumn('kav', 'kav_no_kavling', 'Kav', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for payment field
            //
            $column = new TextViewColumn('payment', 'payment', 'Payment', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Ket', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for id_proyek field
            //
            $editor = new DynamicCombobox('id_proyek_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Proyek', 'id_proyek', 'id_proyek_nama_proyek', 'edit_pemasukan_penjualan_id_proyek_search', $editor, $this->dataset, $lookupDataset, 'id', 'nama_proyek', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for pemasukan field
            //
            $editor = new DynamicCombobox('pemasukan_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`list_pemasukan`');
            $lookupDataset->addFields(
                array(
                    new StringField('id'),
                    new StringField('pemasukan')
                )
            );
            $lookupDataset->setOrderByField('pemasukan', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Pemasukan', 'pemasukan', 'pemasukan_pemasukan', 'edit_pemasukan_penjualan_pemasukan_search', $editor, $this->dataset, $lookupDataset, 'pemasukan', 'pemasukan', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for jumlah field
            //
            $editor = new TextEdit('jumlah_edit');
            $editColumn = new CustomEditColumn('Jumlah', 'jumlah', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for bln field
            //
            $editor = new SpinEdit('bln_edit');
            $editColumn = new CustomEditColumn('Bln', 'bln', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for tgl field
            //
            $editor = new DateTimeEdit('tgl_edit', false, 'd-m-Y');
            $editColumn = new CustomEditColumn('Tgl', 'tgl', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for kav field
            //
            $editor = new DynamicCombobox('kav_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`kavling`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('id_proyek'),
                    new StringField('no_kavling'),
                    new StringField('ket'),
                    new StringField('kategori'),
                    new IntegerField('lb'),
                    new IntegerField('lt'),
                    new IntegerField('hj_bangunan'),
                    new IntegerField('hb_tanah'),
                    new IntegerField('indeks_tanah'),
                    new IntegerField('h_dasar'),
                    new IntegerField('A'),
                    new IntegerField('B1'),
                    new IntegerField('B2'),
                    new IntegerField('B3'),
                    new IntegerField('C'),
                    new IntegerField('D1'),
                    new IntegerField('D2')
                )
            );
            $lookupDataset->setOrderByField('no_kavling', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Kav', 'kav', 'kav_no_kavling', 'edit_pemasukan_penjualan_kav_search', $editor, $this->dataset, $lookupDataset, 'no_kavling', 'no_kavling', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for payment field
            //
            $editor = new TextEdit('payment_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Payment', 'payment', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ket field
            //
            $editor = new TextEdit('ket_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Ket', 'ket', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for id_proyek field
            //
            $editor = new DynamicCombobox('id_proyek_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Proyek', 'id_proyek', 'id_proyek_nama_proyek', 'multi_edit_pemasukan_penjualan_id_proyek_search', $editor, $this->dataset, $lookupDataset, 'id', 'nama_proyek', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for pemasukan field
            //
            $editor = new DynamicCombobox('pemasukan_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`list_pemasukan`');
            $lookupDataset->addFields(
                array(
                    new StringField('id'),
                    new StringField('pemasukan')
                )
            );
            $lookupDataset->setOrderByField('pemasukan', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Pemasukan', 'pemasukan', 'pemasukan_pemasukan', 'multi_edit_pemasukan_penjualan_pemasukan_search', $editor, $this->dataset, $lookupDataset, 'pemasukan', 'pemasukan', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for jumlah field
            //
            $editor = new TextEdit('jumlah_edit');
            $editColumn = new CustomEditColumn('Jumlah', 'jumlah', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for bln field
            //
            $editor = new SpinEdit('bln_edit');
            $editColumn = new CustomEditColumn('Bln', 'bln', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for tgl field
            //
            $editor = new DateTimeEdit('tgl_edit', false, 'd-m-Y');
            $editColumn = new CustomEditColumn('Tgl', 'tgl', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for kav field
            //
            $editor = new DynamicCombobox('kav_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`kavling`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('id_proyek'),
                    new StringField('no_kavling'),
                    new StringField('ket'),
                    new StringField('kategori'),
                    new IntegerField('lb'),
                    new IntegerField('lt'),
                    new IntegerField('hj_bangunan'),
                    new IntegerField('hb_tanah'),
                    new IntegerField('indeks_tanah'),
                    new IntegerField('h_dasar'),
                    new IntegerField('A'),
                    new IntegerField('B1'),
                    new IntegerField('B2'),
                    new IntegerField('B3'),
                    new IntegerField('C'),
                    new IntegerField('D1'),
                    new IntegerField('D2')
                )
            );
            $lookupDataset->setOrderByField('no_kavling', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Kav', 'kav', 'kav_no_kavling', 'multi_edit_pemasukan_penjualan_kav_search', $editor, $this->dataset, $lookupDataset, 'no_kavling', 'no_kavling', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for payment field
            //
            $editor = new TextEdit('payment_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Payment', 'payment', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ket field
            //
            $editor = new TextEdit('ket_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Ket', 'ket', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for id_proyek field
            //
            $editor = new DynamicCombobox('id_proyek_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Proyek', 'id_proyek', 'id_proyek_nama_proyek', 'insert_pemasukan_penjualan_id_proyek_search', $editor, $this->dataset, $lookupDataset, 'id', 'nama_proyek', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for pemasukan field
            //
            $editor = new DynamicCombobox('pemasukan_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`list_pemasukan`');
            $lookupDataset->addFields(
                array(
                    new StringField('id'),
                    new StringField('pemasukan')
                )
            );
            $lookupDataset->setOrderByField('pemasukan', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Pemasukan', 'pemasukan', 'pemasukan_pemasukan', 'insert_pemasukan_penjualan_pemasukan_search', $editor, $this->dataset, $lookupDataset, 'pemasukan', 'pemasukan', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for jumlah field
            //
            $editor = new TextEdit('jumlah_edit');
            $editColumn = new CustomEditColumn('Jumlah', 'jumlah', $editor, $this->dataset);
            $editColumn->SetInsertDefaultValue('0');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for bln field
            //
            $editor = new SpinEdit('bln_edit');
            $editColumn = new CustomEditColumn('Bln', 'bln', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for tgl field
            //
            $editor = new DateTimeEdit('tgl_edit', false, 'd-m-Y');
            $editColumn = new CustomEditColumn('Tgl', 'tgl', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for kav field
            //
            $editor = new DynamicCombobox('kav_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`kavling`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('id_proyek'),
                    new StringField('no_kavling'),
                    new StringField('ket'),
                    new StringField('kategori'),
                    new IntegerField('lb'),
                    new IntegerField('lt'),
                    new IntegerField('hj_bangunan'),
                    new IntegerField('hb_tanah'),
                    new IntegerField('indeks_tanah'),
                    new IntegerField('h_dasar'),
                    new IntegerField('A'),
                    new IntegerField('B1'),
                    new IntegerField('B2'),
                    new IntegerField('B3'),
                    new IntegerField('C'),
                    new IntegerField('D1'),
                    new IntegerField('D2')
                )
            );
            $lookupDataset->setOrderByField('no_kavling', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Kav', 'kav', 'kav_no_kavling', 'insert_pemasukan_penjualan_kav_search', $editor, $this->dataset, $lookupDataset, 'no_kavling', 'no_kavling', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for payment field
            //
            $editor = new TextEdit('payment_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Payment', 'payment', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ket field
            //
            $editor = new TextEdit('ket_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Ket', 'ket', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('id_proyek', 'id_proyek_nama_proyek', 'Proyek', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for pemasukan field
            //
            $column = new TextViewColumn('pemasukan', 'pemasukan_pemasukan', 'Pemasukan', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for jumlah field
            //
            $column = new NumberViewColumn('jumlah', 'jumlah', 'Jumlah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for bln field
            //
            $column = new NumberViewColumn('bln', 'bln', 'Bln', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for tgl field
            //
            $column = new DateTimeViewColumn('tgl', 'tgl', 'Tgl', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('d-m-Y');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_kavling field
            //
            $column = new TextViewColumn('kav', 'kav_no_kavling', 'Kav', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for payment field
            //
            $column = new TextViewColumn('payment', 'payment', 'Payment', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Ket', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('id_proyek', 'id_proyek_nama_proyek', 'Proyek', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for pemasukan field
            //
            $column = new TextViewColumn('pemasukan', 'pemasukan_pemasukan', 'Pemasukan', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for jumlah field
            //
            $column = new NumberViewColumn('jumlah', 'jumlah', 'Jumlah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for bln field
            //
            $column = new NumberViewColumn('bln', 'bln', 'Bln', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for tgl field
            //
            $column = new DateTimeViewColumn('tgl', 'tgl', 'Tgl', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('d-m-Y');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_kavling field
            //
            $column = new TextViewColumn('kav', 'kav_no_kavling', 'Kav', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for payment field
            //
            $column = new TextViewColumn('payment', 'payment', 'Payment', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Ket', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
    
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        
        public function GetEnableModalGridInsert() { return true; }
        public function GetEnableModalSingleRecordView() { return true; }
        
        public function GetEnableModalGridCopy() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $defaultSortedColumns = array();
            $defaultSortedColumns[] = new SortColumn('id', 'DESC');
            $result->setDefaultOrdering($defaultSortedColumns);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(true);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setUseModalMultiEdit(true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            $result->SetTotal('pemasukan', PredefinedAggregate::$Count);
            $result->SetTotal('jumlah', PredefinedAggregate::$Sum);
            $result->SetTotal('kav', PredefinedAggregate::$Count);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->SetHidePageListByDefault(true);
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_pemasukan_penjualan_id_proyek_search', 'id', 'nama_proyek', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`list_pemasukan`');
            $lookupDataset->addFields(
                array(
                    new StringField('id'),
                    new StringField('pemasukan')
                )
            );
            $lookupDataset->setOrderByField('pemasukan', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_pemasukan_penjualan_pemasukan_search', 'pemasukan', 'pemasukan', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`kavling`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('id_proyek'),
                    new StringField('no_kavling'),
                    new StringField('ket'),
                    new StringField('kategori'),
                    new IntegerField('lb'),
                    new IntegerField('lt'),
                    new IntegerField('hj_bangunan'),
                    new IntegerField('hb_tanah'),
                    new IntegerField('indeks_tanah'),
                    new IntegerField('h_dasar'),
                    new IntegerField('A'),
                    new IntegerField('B1'),
                    new IntegerField('B2'),
                    new IntegerField('B3'),
                    new IntegerField('C'),
                    new IntegerField('D1'),
                    new IntegerField('D2')
                )
            );
            $lookupDataset->setOrderByField('no_kavling', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_pemasukan_penjualan_kav_search', 'no_kavling', 'no_kavling', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_pemasukan_penjualan_id_proyek_search', 'id', 'nama_proyek', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`list_pemasukan`');
            $lookupDataset->addFields(
                array(
                    new StringField('id'),
                    new StringField('pemasukan')
                )
            );
            $lookupDataset->setOrderByField('pemasukan', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_pemasukan_penjualan_pemasukan_search', 'pemasukan', 'pemasukan', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`kavling`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('id_proyek'),
                    new StringField('no_kavling'),
                    new StringField('ket'),
                    new StringField('kategori'),
                    new IntegerField('lb'),
                    new IntegerField('lt'),
                    new IntegerField('hj_bangunan'),
                    new IntegerField('hb_tanah'),
                    new IntegerField('indeks_tanah'),
                    new IntegerField('h_dasar'),
                    new IntegerField('A'),
                    new IntegerField('B1'),
                    new IntegerField('B2'),
                    new IntegerField('B3'),
                    new IntegerField('C'),
                    new IntegerField('D1'),
                    new IntegerField('D2')
                )
            );
            $lookupDataset->setOrderByField('no_kavling', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_pemasukan_penjualan_kav_search', 'no_kavling', 'no_kavling', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_pemasukan_penjualan_id_proyek_search', 'id', 'nama_proyek', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`list_pemasukan`');
            $lookupDataset->addFields(
                array(
                    new StringField('id'),
                    new StringField('pemasukan')
                )
            );
            $lookupDataset->setOrderByField('pemasukan', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_pemasukan_penjualan_pemasukan_search', 'pemasukan', 'pemasukan', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`kavling`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('id_proyek'),
                    new StringField('no_kavling'),
                    new StringField('ket'),
                    new StringField('kategori'),
                    new IntegerField('lb'),
                    new IntegerField('lt'),
                    new IntegerField('hj_bangunan'),
                    new IntegerField('hb_tanah'),
                    new IntegerField('indeks_tanah'),
                    new IntegerField('h_dasar'),
                    new IntegerField('A'),
                    new IntegerField('B1'),
                    new IntegerField('B2'),
                    new IntegerField('B3'),
                    new IntegerField('C'),
                    new IntegerField('D1'),
                    new IntegerField('D2')
                )
            );
            $lookupDataset->setOrderByField('no_kavling', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_pemasukan_penjualan_kav_search', 'no_kavling', 'no_kavling', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_pemasukan_penjualan_id_proyek_search', 'id', 'nama_proyek', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`list_pemasukan`');
            $lookupDataset->addFields(
                array(
                    new StringField('id'),
                    new StringField('pemasukan')
                )
            );
            $lookupDataset->setOrderByField('pemasukan', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_pemasukan_penjualan_pemasukan_search', 'pemasukan', 'pemasukan', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`kavling`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('id_proyek'),
                    new StringField('no_kavling'),
                    new StringField('ket'),
                    new StringField('kategori'),
                    new IntegerField('lb'),
                    new IntegerField('lt'),
                    new IntegerField('hj_bangunan'),
                    new IntegerField('hb_tanah'),
                    new IntegerField('indeks_tanah'),
                    new IntegerField('h_dasar'),
                    new IntegerField('A'),
                    new IntegerField('B1'),
                    new IntegerField('B2'),
                    new IntegerField('B3'),
                    new IntegerField('C'),
                    new IntegerField('D1'),
                    new IntegerField('D2')
                )
            );
            $lookupDataset->setOrderByField('no_kavling', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_pemasukan_penjualan_kav_search', 'no_kavling', 'no_kavling', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }

    SetUpUserAuthorization();

    try
    {
        $Page = new pemasukan_penjualanPage("pemasukan_penjualan", "pemasukan_penjualan.php", GetCurrentUserPermissionsForPage("pemasukan_penjualan"), 'UTF-8');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("pemasukan_penjualan"));
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e);
    }
	
