<?php

//  define('SHOW_VARIABLES', 1);
//  define('DEBUG_LEVEL', 1);

//  error_reporting(E_ALL ^ E_NOTICE);
//  ini_set('display_errors', 'On');

set_include_path('.' . PATH_SEPARATOR . get_include_path());


include_once dirname(__FILE__) . '/' . 'components/utils/system_utils.php';
include_once dirname(__FILE__) . '/' . 'components/mail/mailer.php';
include_once dirname(__FILE__) . '/' . 'components/mail/phpmailer_based_mailer.php';
require_once dirname(__FILE__) . '/' . 'database_engine/mysql_engine.php';

//  SystemUtils::DisableMagicQuotesRuntime();

SystemUtils::SetTimeZoneIfNeed('Asia/Krasnoyarsk');

function GetGlobalConnectionOptions()
{
    return
        array(
          'server' => 'localhost',
          'port' => '3306',
          'username' => 'root',
          'database' => 'd6',
          'client_encoding' => 'utf8'
        );
}

function HasAdminPage()
{
    return false;
}

function HasHomePage()
{
    return true;
}

function GetHomeURL()
{
    return 'index.php';
}

function GetHomePageBanner()
{
    return '';
}

function GetPageGroups()
{
    $result = array();
    $result[] = array('caption' => 'Penjualan Proyek', 'description' => '');
    $result[] = array('caption' => 'RAB', 'description' => '');
    $result[] = array('caption' => 'Distribusi Biaya', 'description' => '');
    $result[] = array('caption' => 'Arus Kas', 'description' => '');
    return $result;
}

function GetPageInfos()
{
    $result = array();
    $result[] = array('caption' => 'Proyek', 'short_caption' => 'Proyek', 'filename' => 'query_proyek.php', 'name' => 'query_proyek', 'group_name' => 'Penjualan Proyek', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'Pendekatan Harga Jual', 'short_caption' => 'Pendekatan Harga Jual', 'filename' => 'query_pendekatan_harga_jual.php', 'name' => 'query_pendekatan_harga_jual', 'group_name' => 'Penjualan Proyek', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'RAB HPP', 'short_caption' => 'RAB HPP', 'filename' => 'query_rab_head_total.php', 'name' => 'query_rab_head_total', 'group_name' => 'RAB', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'RAB BOP', 'short_caption' => 'RAB BOP', 'filename' => 'query_bop_head_total.php', 'name' => 'query_bop_head_total', 'group_name' => 'RAB', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'Distribusi Biaya HPP', 'short_caption' => 'Distribusi Biaya HPP', 'filename' => 'query_distribusi_biaya_hpp.php', 'name' => 'query_distribusi_biaya_hpp', 'group_name' => 'Distribusi Biaya', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'Distribusi Biaya HPP & BOP', 'short_caption' => 'Distribusi Biaya HPP & BOP', 'filename' => 'query_distribusi_biaya_hpp_bop.php', 'name' => 'query_distribusi_biaya_hpp_bop', 'group_name' => 'Distribusi Biaya', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'Target Penjualan', 'short_caption' => 'Target Penjualan', 'filename' => 'query_target_penjualan.php', 'name' => 'query_target_penjualan', 'group_name' => 'Penjualan Proyek', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'Cashflow Pembangunan', 'short_caption' => 'Cashflow Pembangunan', 'filename' => 'query_cashflow_pembangunan.php', 'name' => 'query_cashflow_pembangunan', 'group_name' => 'Penjualan Proyek', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'A. Pemasukan Penjualan', 'short_caption' => 'A. Pemasukan Penjualan', 'filename' => 'query_kas_pemasukan_penjualan.php', 'name' => 'query_kas_pemasukan_penjualan', 'group_name' => 'Arus Kas', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => '--> Input Pemasukan Penjualan', 'short_caption' => 'Input Pemasukan Penjualan', 'filename' => 'pemasukan_penjualan.php', 'name' => 'pemasukan_penjualan', 'group_name' => 'Arus Kas', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'B. Pengeluaran HPP', 'short_caption' => 'B. Pengeluaran HPP', 'filename' => 'query_pengeluaran_hpp.php', 'name' => 'query_pengeluaran_hpp', 'group_name' => 'Arus Kas', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => '--> Input Pengeluaran HPP', 'short_caption' => 'Input Pengeluaran HPP', 'filename' => 'pengeluaran_hpp.php', 'name' => 'pengeluaran_hpp', 'group_name' => 'Arus Kas', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'C. Pengeluaran BOP', 'short_caption' => 'C. Pengeluaran BOP', 'filename' => 'query_pengeluaran_bop.php', 'name' => 'query_pengeluaran_bop', 'group_name' => 'Arus Kas', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => '--> Input Pengeluaran BOP', 'short_caption' => 'Input Pengeluaran BOP', 'filename' => 'pengeluaran_bop.php', 'name' => 'pengeluaran_bop', 'group_name' => 'Arus Kas', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'D. Rencana Modal', 'short_caption' => 'D. Rencana Modal', 'filename' => 'query_rencana_modal.php', 'name' => 'query_rencana_modal', 'group_name' => 'Arus Kas', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'E. Pengembalian Modal', 'short_caption' => 'E. Pengembalian Modal', 'filename' => 'query_pengembalian_modal.php', 'name' => 'query_pengembalian_modal', 'group_name' => 'Arus Kas', 'add_separator' => false, 'description' => '');
    return $result;
}

function GetPagesHeader()
{
    return
        '';
}

function GetPagesFooter()
{
    return
        '';
}

function ApplyCommonPageSettings(Page $page, Grid $grid)
{
    $page->SetShowUserAuthBar(false);
    $page->setShowNavigation(false);
    $page->OnGetCustomExportOptions->AddListener('Global_OnGetCustomExportOptions');
    $page->getDataset()->OnGetFieldValue->AddListener('Global_OnGetFieldValue');
    $page->getDataset()->OnGetFieldValue->AddListener('OnGetFieldValue', $page);
    $grid->BeforeUpdateRecord->AddListener('Global_BeforeUpdateHandler');
    $grid->BeforeDeleteRecord->AddListener('Global_BeforeDeleteHandler');
    $grid->BeforeInsertRecord->AddListener('Global_BeforeInsertHandler');
    $grid->AfterUpdateRecord->AddListener('Global_AfterUpdateHandler');
    $grid->AfterDeleteRecord->AddListener('Global_AfterDeleteHandler');
    $grid->AfterInsertRecord->AddListener('Global_AfterInsertHandler');
}

function GetAnsiEncoding() { return 'windows-1252'; }

function Global_AddEnvironmentVariablesHandler(&$variables)
{

}

function Global_CustomHTMLHeaderHandler($page, &$customHtmlHeaderText)
{

}

function Global_GetCustomTemplateHandler($type, $part, $mode, &$result, &$params, CommonPage $page = null)
{

}

function Global_OnGetCustomExportOptions($page, $exportType, $rowData, &$options)
{

}

function Global_OnGetFieldValue($fieldName, &$value, $tableName)
{

}

function Global_GetCustomPageList(CommonPage $page, PageList $pageList)
{

}

function Global_BeforeInsertHandler($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
{

}

function Global_BeforeUpdateHandler($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
{

}

function Global_BeforeDeleteHandler($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
{

}

function Global_AfterInsertHandler($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
{

}

function Global_AfterUpdateHandler($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
{

}

function Global_AfterDeleteHandler($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
{

}

function GetDefaultDateFormat()
{
    return 'd-m-Y';
}

function GetFirstDayOfWeek()
{
    return 0;
}

function GetPageListType()
{
    return PageList::TYPE_MENU;
}

function GetNullLabel()
{
    return '-';
}

function UseMinifiedJS()
{
    return true;
}

function GetOfflineMode()
{
    return false;
}

function GetInactivityTimeout()
{
    return 0;
}

function GetMailer()
{
    $mailerOptions = new MailerOptions(MailerType::Sendmail, '', '');
    
    return PHPMailerBasedMailer::getInstance($mailerOptions);
}

function sendMailMessage($recipients, $messageSubject, $messageBody, $attachments = '', $cc = '', $bcc = '')
{
    GetMailer()->send($recipients, $messageSubject, $messageBody, $attachments, $cc, $bcc);
}

function createConnection()
{
    $connectionOptions = GetGlobalConnectionOptions();
    $connectionOptions['client_encoding'] = 'utf8';

    $connectionFactory = MySqlIConnectionFactory::getInstance();
    return $connectionFactory->CreateConnection($connectionOptions);
}

/**
 * @param string $pageName
 * @return IPermissionSet
 */
function GetCurrentUserPermissionsForPage($pageName) 
{
    return GetApplication()->GetCurrentUserPermissionSet($pageName);
}
