<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/mysql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class query_distribusi_biaya_hppPage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Distribusi Biaya HPP');
            $this->SetMenuLabel('Distribusi Biaya HPP');
    
            $this->dataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`query_distribusi_biaya_hpp`');
            $this->dataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('id_proyek'),
                    new StringField('no_kavling'),
                    new IntegerField('lb'),
                    new IntegerField('lt'),
                    new StringField('ket'),
                    new IntegerField('tanah_proyek'),
                    new IntegerField('pengolahan_lahan'),
                    new IntegerField('prasarana_sarana'),
                    new IntegerField('kontruksi_rumah'),
                    new IntegerField('perijinan_proyek'),
                    new IntegerField('legalitas_proyek'),
                    new IntegerField('legalitas_pjl_kav'),
                    new IntegerField('hpp'),
                    new IntegerField('harga_min_jual'),
                    new IntegerField('laba_kotor'),
                    new IntegerField('prosentase_laba')
                )
            );
            $this->dataset->AddLookupField('id_proyek', 'proyek', new IntegerField('id'), new StringField('nama_proyek', false, false, false, false, 'id_proyek_nama_proyek', 'id_proyek_nama_proyek_proyek'), 'id_proyek_nama_proyek_proyek');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id', 'id', 'Id'),
                new FilterColumn($this->dataset, 'id_proyek', 'id_proyek_nama_proyek', 'Proyek'),
                new FilterColumn($this->dataset, 'no_kavling', 'no_kavling', 'Kavling'),
                new FilterColumn($this->dataset, 'lb', 'lb', 'LB'),
                new FilterColumn($this->dataset, 'lt', 'lt', 'LT'),
                new FilterColumn($this->dataset, 'ket', 'ket', 'Keterangan'),
                new FilterColumn($this->dataset, 'tanah_proyek', 'tanah_proyek', 'Tanah Proyek'),
                new FilterColumn($this->dataset, 'pengolahan_lahan', 'pengolahan_lahan', 'Pengolahan Lahan'),
                new FilterColumn($this->dataset, 'prasarana_sarana', 'prasarana_sarana', 'Prasarana Sarana'),
                new FilterColumn($this->dataset, 'kontruksi_rumah', 'kontruksi_rumah', 'Kontruksi Rumah'),
                new FilterColumn($this->dataset, 'perijinan_proyek', 'perijinan_proyek', 'Perijinan Proyek'),
                new FilterColumn($this->dataset, 'legalitas_proyek', 'legalitas_proyek', 'Legalitas Proyek'),
                new FilterColumn($this->dataset, 'legalitas_pjl_kav', 'legalitas_pjl_kav', 'Legalitas Penj Kav'),
                new FilterColumn($this->dataset, 'hpp', 'hpp', 'H_Pokok Produksi'),
                new FilterColumn($this->dataset, 'harga_min_jual', 'harga_min_jual', 'Harga Min Jual'),
                new FilterColumn($this->dataset, 'laba_kotor', 'laba_kotor', 'Laba Kotor'),
                new FilterColumn($this->dataset, 'prosentase_laba', 'prosentase_laba', '% Laba')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_proyek'])
                ->addColumn($columns['no_kavling'])
                ->addColumn($columns['lb'])
                ->addColumn($columns['lt'])
                ->addColumn($columns['ket'])
                ->addColumn($columns['tanah_proyek'])
                ->addColumn($columns['pengolahan_lahan'])
                ->addColumn($columns['prasarana_sarana'])
                ->addColumn($columns['kontruksi_rumah'])
                ->addColumn($columns['perijinan_proyek'])
                ->addColumn($columns['legalitas_proyek'])
                ->addColumn($columns['legalitas_pjl_kav'])
                ->addColumn($columns['hpp'])
                ->addColumn($columns['harga_min_jual'])
                ->addColumn($columns['laba_kotor'])
                ->addColumn($columns['prosentase_laba']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_proyek')
                ->setOptionsFor('lb')
                ->setOptionsFor('lt')
                ->setOptionsFor('ket')
                ->setOptionsFor('tanah_proyek')
                ->setOptionsFor('pengolahan_lahan')
                ->setOptionsFor('prasarana_sarana')
                ->setOptionsFor('kontruksi_rumah')
                ->setOptionsFor('perijinan_proyek')
                ->setOptionsFor('legalitas_proyek')
                ->setOptionsFor('legalitas_pjl_kav')
                ->setOptionsFor('hpp')
                ->setOptionsFor('harga_min_jual')
                ->setOptionsFor('laba_kotor')
                ->setOptionsFor('prosentase_laba');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new DynamicCombobox('id_proyek_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_query_distribusi_biaya_hpp_id_proyek_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_proyek', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_query_distribusi_biaya_hpp_id_proyek_search');
            
            $filterBuilder->addColumn(
                $columns['id_proyek'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_kavling_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['no_kavling'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('lb_edit');
            
            $filterBuilder->addColumn(
                $columns['lb'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('lt_edit');
            
            $filterBuilder->addColumn(
                $columns['lt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ket_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['ket'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('tanah_proyek_edit');
            
            $filterBuilder->addColumn(
                $columns['tanah_proyek'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('pengolahan_lahan_edit');
            
            $filterBuilder->addColumn(
                $columns['pengolahan_lahan'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prasarana_sarana_edit');
            
            $filterBuilder->addColumn(
                $columns['prasarana_sarana'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('kontruksi_rumah_edit');
            
            $filterBuilder->addColumn(
                $columns['kontruksi_rumah'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('perijinan_proyek_edit');
            
            $filterBuilder->addColumn(
                $columns['perijinan_proyek'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('legalitas_proyek_edit');
            
            $filterBuilder->addColumn(
                $columns['legalitas_proyek'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('legalitas_pjl_kav_edit');
            
            $filterBuilder->addColumn(
                $columns['legalitas_pjl_kav'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('hpp_edit');
            
            $filterBuilder->addColumn(
                $columns['hpp'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('harga_min_jual_edit');
            
            $filterBuilder->addColumn(
                $columns['harga_min_jual'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('laba_kotor_edit');
            
            $filterBuilder->addColumn(
                $columns['laba_kotor'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prosentase_laba_edit');
            
            $filterBuilder->addColumn(
                $columns['prosentase_laba'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
    
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('id_proyek', 'id_proyek_nama_proyek', 'Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_kavling field
            //
            $column = new TextViewColumn('no_kavling', 'no_kavling', 'Kavling', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for lb field
            //
            $column = new NumberViewColumn('lb', 'lb', 'LB', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for lt field
            //
            $column = new NumberViewColumn('lt', 'lt', 'LT', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Keterangan', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for tanah_proyek field
            //
            $column = new NumberViewColumn('tanah_proyek', 'tanah_proyek', 'Tanah Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for pengolahan_lahan field
            //
            $column = new NumberViewColumn('pengolahan_lahan', 'pengolahan_lahan', 'Pengolahan Lahan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prasarana_sarana field
            //
            $column = new NumberViewColumn('prasarana_sarana', 'prasarana_sarana', 'Prasarana Sarana', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for kontruksi_rumah field
            //
            $column = new NumberViewColumn('kontruksi_rumah', 'kontruksi_rumah', 'Kontruksi Rumah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for perijinan_proyek field
            //
            $column = new NumberViewColumn('perijinan_proyek', 'perijinan_proyek', 'Perijinan Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for legalitas_proyek field
            //
            $column = new NumberViewColumn('legalitas_proyek', 'legalitas_proyek', 'Legalitas Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for legalitas_pjl_kav field
            //
            $column = new NumberViewColumn('legalitas_pjl_kav', 'legalitas_pjl_kav', 'Legalitas Penj Kav', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for hpp field
            //
            $column = new NumberViewColumn('hpp', 'hpp', 'H_Pokok Produksi', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for harga_min_jual field
            //
            $column = new NumberViewColumn('harga_min_jual', 'harga_min_jual', 'Harga Min Jual', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for laba_kotor field
            //
            $column = new NumberViewColumn('laba_kotor', 'laba_kotor', 'Laba Kotor', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prosentase_laba field
            //
            $column = new PercentViewColumn('prosentase_laba', 'prosentase_laba', '% Laba', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('id_proyek', 'id_proyek_nama_proyek', 'Proyek', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_kavling field
            //
            $column = new TextViewColumn('no_kavling', 'no_kavling', 'Kavling', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for lb field
            //
            $column = new NumberViewColumn('lb', 'lb', 'LB', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for lt field
            //
            $column = new NumberViewColumn('lt', 'lt', 'LT', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Keterangan', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for tanah_proyek field
            //
            $column = new NumberViewColumn('tanah_proyek', 'tanah_proyek', 'Tanah Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for pengolahan_lahan field
            //
            $column = new NumberViewColumn('pengolahan_lahan', 'pengolahan_lahan', 'Pengolahan Lahan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prasarana_sarana field
            //
            $column = new NumberViewColumn('prasarana_sarana', 'prasarana_sarana', 'Prasarana Sarana', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for kontruksi_rumah field
            //
            $column = new NumberViewColumn('kontruksi_rumah', 'kontruksi_rumah', 'Kontruksi Rumah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for perijinan_proyek field
            //
            $column = new NumberViewColumn('perijinan_proyek', 'perijinan_proyek', 'Perijinan Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for legalitas_proyek field
            //
            $column = new NumberViewColumn('legalitas_proyek', 'legalitas_proyek', 'Legalitas Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for legalitas_pjl_kav field
            //
            $column = new NumberViewColumn('legalitas_pjl_kav', 'legalitas_pjl_kav', 'Legalitas Penj Kav', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for hpp field
            //
            $column = new NumberViewColumn('hpp', 'hpp', 'H_Pokok Produksi', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for harga_min_jual field
            //
            $column = new NumberViewColumn('harga_min_jual', 'harga_min_jual', 'Harga Min Jual', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for laba_kotor field
            //
            $column = new NumberViewColumn('laba_kotor', 'laba_kotor', 'Laba Kotor', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prosentase_laba field
            //
            $column = new PercentViewColumn('prosentase_laba', 'prosentase_laba', '% Laba', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for no_kavling field
            //
            $editor = new TextEdit('no_kavling_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Kavling', 'no_kavling', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for lb field
            //
            $editor = new TextEdit('lb_edit');
            $editColumn = new CustomEditColumn('LB', 'lb', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for lt field
            //
            $editor = new TextEdit('lt_edit');
            $editColumn = new CustomEditColumn('LT', 'lt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ket field
            //
            $editor = new TextEdit('ket_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Keterangan', 'ket', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for tanah_proyek field
            //
            $editor = new TextEdit('tanah_proyek_edit');
            $editColumn = new CustomEditColumn('Tanah Proyek', 'tanah_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for pengolahan_lahan field
            //
            $editor = new TextEdit('pengolahan_lahan_edit');
            $editColumn = new CustomEditColumn('Pengolahan Lahan', 'pengolahan_lahan', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prasarana_sarana field
            //
            $editor = new TextEdit('prasarana_sarana_edit');
            $editColumn = new CustomEditColumn('Prasarana Sarana', 'prasarana_sarana', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for kontruksi_rumah field
            //
            $editor = new TextEdit('kontruksi_rumah_edit');
            $editColumn = new CustomEditColumn('Kontruksi Rumah', 'kontruksi_rumah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for perijinan_proyek field
            //
            $editor = new TextEdit('perijinan_proyek_edit');
            $editColumn = new CustomEditColumn('Perijinan Proyek', 'perijinan_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for legalitas_proyek field
            //
            $editor = new TextEdit('legalitas_proyek_edit');
            $editColumn = new CustomEditColumn('Legalitas Proyek', 'legalitas_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for legalitas_pjl_kav field
            //
            $editor = new TextEdit('legalitas_pjl_kav_edit');
            $editColumn = new CustomEditColumn('Legalitas Penj Kav', 'legalitas_pjl_kav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for hpp field
            //
            $editor = new TextEdit('hpp_edit');
            $editColumn = new CustomEditColumn('H_Pokok Produksi', 'hpp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for harga_min_jual field
            //
            $editor = new TextEdit('harga_min_jual_edit');
            $editColumn = new CustomEditColumn('Harga Min Jual', 'harga_min_jual', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for laba_kotor field
            //
            $editor = new TextEdit('laba_kotor_edit');
            $editColumn = new CustomEditColumn('Laba Kotor', 'laba_kotor', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prosentase_laba field
            //
            $editor = new TextEdit('prosentase_laba_edit');
            $editColumn = new CustomEditColumn('% Laba', 'prosentase_laba', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for no_kavling field
            //
            $editor = new TextEdit('no_kavling_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Kavling', 'no_kavling', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for lb field
            //
            $editor = new TextEdit('lb_edit');
            $editColumn = new CustomEditColumn('LB', 'lb', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for lt field
            //
            $editor = new TextEdit('lt_edit');
            $editColumn = new CustomEditColumn('LT', 'lt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ket field
            //
            $editor = new TextEdit('ket_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Keterangan', 'ket', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for tanah_proyek field
            //
            $editor = new TextEdit('tanah_proyek_edit');
            $editColumn = new CustomEditColumn('Tanah Proyek', 'tanah_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for pengolahan_lahan field
            //
            $editor = new TextEdit('pengolahan_lahan_edit');
            $editColumn = new CustomEditColumn('Pengolahan Lahan', 'pengolahan_lahan', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prasarana_sarana field
            //
            $editor = new TextEdit('prasarana_sarana_edit');
            $editColumn = new CustomEditColumn('Prasarana Sarana', 'prasarana_sarana', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for kontruksi_rumah field
            //
            $editor = new TextEdit('kontruksi_rumah_edit');
            $editColumn = new CustomEditColumn('Kontruksi Rumah', 'kontruksi_rumah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for perijinan_proyek field
            //
            $editor = new TextEdit('perijinan_proyek_edit');
            $editColumn = new CustomEditColumn('Perijinan Proyek', 'perijinan_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for legalitas_proyek field
            //
            $editor = new TextEdit('legalitas_proyek_edit');
            $editColumn = new CustomEditColumn('Legalitas Proyek', 'legalitas_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for legalitas_pjl_kav field
            //
            $editor = new TextEdit('legalitas_pjl_kav_edit');
            $editColumn = new CustomEditColumn('Legalitas Penj Kav', 'legalitas_pjl_kav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for hpp field
            //
            $editor = new TextEdit('hpp_edit');
            $editColumn = new CustomEditColumn('H_Pokok Produksi', 'hpp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for harga_min_jual field
            //
            $editor = new TextEdit('harga_min_jual_edit');
            $editColumn = new CustomEditColumn('Harga Min Jual', 'harga_min_jual', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for laba_kotor field
            //
            $editor = new TextEdit('laba_kotor_edit');
            $editColumn = new CustomEditColumn('Laba Kotor', 'laba_kotor', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prosentase_laba field
            //
            $editor = new TextEdit('prosentase_laba_edit');
            $editColumn = new CustomEditColumn('% Laba', 'prosentase_laba', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for no_kavling field
            //
            $editor = new TextEdit('no_kavling_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Kavling', 'no_kavling', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for lb field
            //
            $editor = new TextEdit('lb_edit');
            $editColumn = new CustomEditColumn('LB', 'lb', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for lt field
            //
            $editor = new TextEdit('lt_edit');
            $editColumn = new CustomEditColumn('LT', 'lt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ket field
            //
            $editor = new TextEdit('ket_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Keterangan', 'ket', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for tanah_proyek field
            //
            $editor = new TextEdit('tanah_proyek_edit');
            $editColumn = new CustomEditColumn('Tanah Proyek', 'tanah_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for pengolahan_lahan field
            //
            $editor = new TextEdit('pengolahan_lahan_edit');
            $editColumn = new CustomEditColumn('Pengolahan Lahan', 'pengolahan_lahan', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prasarana_sarana field
            //
            $editor = new TextEdit('prasarana_sarana_edit');
            $editColumn = new CustomEditColumn('Prasarana Sarana', 'prasarana_sarana', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for kontruksi_rumah field
            //
            $editor = new TextEdit('kontruksi_rumah_edit');
            $editColumn = new CustomEditColumn('Kontruksi Rumah', 'kontruksi_rumah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for perijinan_proyek field
            //
            $editor = new TextEdit('perijinan_proyek_edit');
            $editColumn = new CustomEditColumn('Perijinan Proyek', 'perijinan_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for legalitas_proyek field
            //
            $editor = new TextEdit('legalitas_proyek_edit');
            $editColumn = new CustomEditColumn('Legalitas Proyek', 'legalitas_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for legalitas_pjl_kav field
            //
            $editor = new TextEdit('legalitas_pjl_kav_edit');
            $editColumn = new CustomEditColumn('Legalitas Penj Kav', 'legalitas_pjl_kav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for hpp field
            //
            $editor = new TextEdit('hpp_edit');
            $editColumn = new CustomEditColumn('H_Pokok Produksi', 'hpp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for harga_min_jual field
            //
            $editor = new TextEdit('harga_min_jual_edit');
            $editColumn = new CustomEditColumn('Harga Min Jual', 'harga_min_jual', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for laba_kotor field
            //
            $editor = new TextEdit('laba_kotor_edit');
            $editColumn = new CustomEditColumn('Laba Kotor', 'laba_kotor', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prosentase_laba field
            //
            $editor = new TextEdit('prosentase_laba_edit');
            $editColumn = new CustomEditColumn('% Laba', 'prosentase_laba', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(false && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('id_proyek', 'id_proyek_nama_proyek', 'Proyek', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_kavling field
            //
            $column = new TextViewColumn('no_kavling', 'no_kavling', 'Kavling', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for lb field
            //
            $column = new NumberViewColumn('lb', 'lb', 'LB', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for lt field
            //
            $column = new NumberViewColumn('lt', 'lt', 'LT', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Keterangan', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for tanah_proyek field
            //
            $column = new NumberViewColumn('tanah_proyek', 'tanah_proyek', 'Tanah Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for pengolahan_lahan field
            //
            $column = new NumberViewColumn('pengolahan_lahan', 'pengolahan_lahan', 'Pengolahan Lahan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for prasarana_sarana field
            //
            $column = new NumberViewColumn('prasarana_sarana', 'prasarana_sarana', 'Prasarana Sarana', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for kontruksi_rumah field
            //
            $column = new NumberViewColumn('kontruksi_rumah', 'kontruksi_rumah', 'Kontruksi Rumah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for perijinan_proyek field
            //
            $column = new NumberViewColumn('perijinan_proyek', 'perijinan_proyek', 'Perijinan Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for legalitas_proyek field
            //
            $column = new NumberViewColumn('legalitas_proyek', 'legalitas_proyek', 'Legalitas Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for legalitas_pjl_kav field
            //
            $column = new NumberViewColumn('legalitas_pjl_kav', 'legalitas_pjl_kav', 'Legalitas Penj Kav', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for hpp field
            //
            $column = new NumberViewColumn('hpp', 'hpp', 'H_Pokok Produksi', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for harga_min_jual field
            //
            $column = new NumberViewColumn('harga_min_jual', 'harga_min_jual', 'Harga Min Jual', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for laba_kotor field
            //
            $column = new NumberViewColumn('laba_kotor', 'laba_kotor', 'Laba Kotor', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for prosentase_laba field
            //
            $column = new PercentViewColumn('prosentase_laba', 'prosentase_laba', '% Laba', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('id_proyek', 'id_proyek_nama_proyek', 'Proyek', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_kavling field
            //
            $column = new TextViewColumn('no_kavling', 'no_kavling', 'Kavling', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for lb field
            //
            $column = new NumberViewColumn('lb', 'lb', 'LB', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for lt field
            //
            $column = new NumberViewColumn('lt', 'lt', 'LT', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Keterangan', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for tanah_proyek field
            //
            $column = new NumberViewColumn('tanah_proyek', 'tanah_proyek', 'Tanah Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for pengolahan_lahan field
            //
            $column = new NumberViewColumn('pengolahan_lahan', 'pengolahan_lahan', 'Pengolahan Lahan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for prasarana_sarana field
            //
            $column = new NumberViewColumn('prasarana_sarana', 'prasarana_sarana', 'Prasarana Sarana', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for kontruksi_rumah field
            //
            $column = new NumberViewColumn('kontruksi_rumah', 'kontruksi_rumah', 'Kontruksi Rumah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for perijinan_proyek field
            //
            $column = new NumberViewColumn('perijinan_proyek', 'perijinan_proyek', 'Perijinan Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for legalitas_proyek field
            //
            $column = new NumberViewColumn('legalitas_proyek', 'legalitas_proyek', 'Legalitas Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for legalitas_pjl_kav field
            //
            $column = new NumberViewColumn('legalitas_pjl_kav', 'legalitas_pjl_kav', 'Legalitas Penj Kav', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for hpp field
            //
            $column = new NumberViewColumn('hpp', 'hpp', 'H_Pokok Produksi', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for harga_min_jual field
            //
            $column = new NumberViewColumn('harga_min_jual', 'harga_min_jual', 'Harga Min Jual', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for laba_kotor field
            //
            $column = new NumberViewColumn('laba_kotor', 'laba_kotor', 'Laba Kotor', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for prosentase_laba field
            //
            $column = new PercentViewColumn('prosentase_laba', 'prosentase_laba', '% Laba', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
    
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(false);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(true);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && false);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            $result->SetTotal('id_proyek', PredefinedAggregate::$Sum);
            $result->SetTotal('lb', PredefinedAggregate::$Sum);
            $result->SetTotal('lt', PredefinedAggregate::$Sum);
            $result->SetTotal('tanah_proyek', PredefinedAggregate::$Sum);
            $result->SetTotal('pengolahan_lahan', PredefinedAggregate::$Sum);
            $result->SetTotal('prasarana_sarana', PredefinedAggregate::$Sum);
            $result->SetTotal('kontruksi_rumah', PredefinedAggregate::$Sum);
            $result->SetTotal('perijinan_proyek', PredefinedAggregate::$Sum);
            $result->SetTotal('legalitas_proyek', PredefinedAggregate::$Sum);
            $result->SetTotal('legalitas_pjl_kav', PredefinedAggregate::$Sum);
            $result->SetTotal('hpp', PredefinedAggregate::$Sum);
            $result->SetTotal('harga_min_jual', PredefinedAggregate::$Sum);
            $result->SetTotal('laba_kotor', PredefinedAggregate::$Sum);
            $result->SetTotal('prosentase_laba', PredefinedAggregate::$Average);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array());
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->SetHidePageListByDefault(true);
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_query_distribusi_biaya_hpp_id_proyek_search', 'id', 'nama_proyek', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
            $columnGroup->add(new ViewColumnGroup('Type / Luas',
                            array(
                                $columns['id_proyek'],
                                $columns['no_kavling'],
                                 $columns['lb'],
                                $columns['lt'],
                                $columns['ket']
                                //$columns['kategori']                  
                                
                            )
                       
                        ));
                        
                        $columnGroup->add(new ViewColumnGroup('Perhitungan HPP',
                            array(
                                $columns['tanah_proyek'],
                                $columns['pengolahan_lahan'],
                                $columns['prasarana_sarana'],                    
                                $columns['tanah_proyek'],
                                $columns['kontruksi_rumah'],
                                $columns['perijinan_proyek'],
                                $columns['legalitas_proyek'],
                                 $columns['legalitas_pjl_kav']
                                
                            )
                        ));
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }

    SetUpUserAuthorization();

    try
    {
        $Page = new query_distribusi_biaya_hppPage("query_distribusi_biaya_hpp", "query_distribusi_biaya_hpp.php", GetCurrentUserPermissionsForPage("query_distribusi_biaya_hpp"), 'UTF-8');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("query_distribusi_biaya_hpp"));
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e);
    }
	
