<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/mysql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class query_pendekatan_harga_jualPage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Pendekatan Harga Jual');
            $this->SetMenuLabel('Pendekatan Harga Jual');
    
            $this->dataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`query_pendekatan_harga_jual`');
            $this->dataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('id_proyek'),
                    new StringField('no_kavling'),
                    new StringField('ket'),
                    new StringField('kategori'),
                    new IntegerField('lb'),
                    new IntegerField('lt'),
                    new IntegerField('hj_bangunan'),
                    new IntegerField('hb_tanah'),
                    new IntegerField('indeks_tanah'),
                    new IntegerField('h_dasar'),
                    new IntegerField('harga_tanah'),
                    new IntegerField('harga_jual_raw'),
                    new IntegerField('harga_jual'),
                    new IntegerField('harga_kelebihan_tanah')
                )
            );
            $this->dataset->AddLookupField('id_proyek', 'proyek', new IntegerField('id'), new StringField('nama_proyek', false, false, false, false, 'id_proyek_nama_proyek', 'id_proyek_nama_proyek_proyek'), 'id_proyek_nama_proyek_proyek');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id', 'id', 'Id'),
                new FilterColumn($this->dataset, 'id_proyek', 'id_proyek_nama_proyek', 'Perumahan'),
                new FilterColumn($this->dataset, 'no_kavling', 'no_kavling', 'Nomor'),
                new FilterColumn($this->dataset, 'ket', 'ket', 'Keterangan'),
                new FilterColumn($this->dataset, 'kategori', 'kategori', 'Kategori'),
                new FilterColumn($this->dataset, 'lb', 'lb', 'Bangunan'),
                new FilterColumn($this->dataset, 'lt', 'lt', 'Kavling'),
                new FilterColumn($this->dataset, 'hj_bangunan', 'hj_bangunan', 'Bangunan'),
                new FilterColumn($this->dataset, 'harga_tanah', 'harga_tanah', 'Tanah'),
                new FilterColumn($this->dataset, 'hb_tanah', 'hb_tanah', 'Hb Tanah'),
                new FilterColumn($this->dataset, 'indeks_tanah', 'indeks_tanah', 'Indeks Tanah'),
                new FilterColumn($this->dataset, 'h_dasar', 'h_dasar', 'Harga Dasar'),
                new FilterColumn($this->dataset, 'harga_jual_raw', 'harga_jual_raw', 'Harga Jual Raw'),
                new FilterColumn($this->dataset, 'harga_kelebihan_tanah', 'harga_kelebihan_tanah', 'Harga Kelebihan Tanah'),
                new FilterColumn($this->dataset, 'harga_jual', 'harga_jual', 'Harga Jual')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_proyek'])
                ->addColumn($columns['no_kavling'])
                ->addColumn($columns['ket'])
                ->addColumn($columns['kategori'])
                ->addColumn($columns['lb'])
                ->addColumn($columns['lt'])
                ->addColumn($columns['hj_bangunan'])
                ->addColumn($columns['harga_tanah'])
                ->addColumn($columns['indeks_tanah'])
                ->addColumn($columns['h_dasar'])
                ->addColumn($columns['harga_kelebihan_tanah'])
                ->addColumn($columns['harga_jual']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_proyek')
                ->setOptionsFor('no_kavling')
                ->setOptionsFor('ket')
                ->setOptionsFor('kategori')
                ->setOptionsFor('lb')
                ->setOptionsFor('lt')
                ->setOptionsFor('hj_bangunan')
                ->setOptionsFor('harga_tanah')
                ->setOptionsFor('indeks_tanah')
                ->setOptionsFor('harga_kelebihan_tanah')
                ->setOptionsFor('harga_jual');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new DynamicCombobox('id_proyek_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_query_pendekatan_harga_jual_id_proyek_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_proyek', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_query_pendekatan_harga_jual_id_proyek_search');
            
            $filterBuilder->addColumn(
                $columns['id_proyek'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_kavling_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['no_kavling'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ket_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['ket'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('kategori_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['kategori'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('lb_edit');
            
            $filterBuilder->addColumn(
                $columns['lb'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('lt_edit');
            
            $filterBuilder->addColumn(
                $columns['lt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('hj_bangunan_edit');
            
            $filterBuilder->addColumn(
                $columns['hj_bangunan'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('harga_tanah_edit');
            
            $filterBuilder->addColumn(
                $columns['harga_tanah'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('indeks_tanah_edit');
            
            $filterBuilder->addColumn(
                $columns['indeks_tanah'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('h_dasar_edit');
            
            $filterBuilder->addColumn(
                $columns['h_dasar'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('harga_kelebihan_tanah_edit');
            
            $filterBuilder->addColumn(
                $columns['harga_kelebihan_tanah'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('harga_jual_edit');
            
            $filterBuilder->addColumn(
                $columns['harga_jual'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant()) {
            
                $operation = new AjaxOperation(OPERATION_VIEW,
                    $this->GetLocalizerCaptions()->GetMessageString('View'),
                    $this->GetLocalizerCaptions()->GetMessageString('View'), $this->dataset,
                    $this->GetModalGridViewHandler(), $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new AjaxOperation(OPERATION_EDIT,
                    $this->GetLocalizerCaptions()->GetMessageString('Edit'),
                    $this->GetLocalizerCaptions()->GetMessageString('Edit'), $this->dataset,
                    $this->GetGridEditHandler(), $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new AjaxOperation(OPERATION_COPY,
                    $this->GetLocalizerCaptions()->GetMessageString('Copy'),
                    $this->GetLocalizerCaptions()->GetMessageString('Copy'), $this->dataset,
                    $this->GetModalGridCopyHandler(), $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('id_proyek', 'id_proyek_nama_proyek', 'Perumahan', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_kavling field
            //
            $column = new TextViewColumn('no_kavling', 'no_kavling', 'Nomor', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Keterangan', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for kategori field
            //
            $column = new TextViewColumn('kategori', 'kategori', 'Kategori', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for lb field
            //
            $column = new NumberViewColumn('lb', 'lb', 'Bangunan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for lt field
            //
            $column = new NumberViewColumn('lt', 'lt', 'Kavling', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for hj_bangunan field
            //
            $column = new NumberViewColumn('hj_bangunan', 'hj_bangunan', 'Bangunan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for harga_tanah field
            //
            $column = new NumberViewColumn('harga_tanah', 'harga_tanah', 'Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for indeks_tanah field
            //
            $column = new NumberViewColumn('indeks_tanah', 'indeks_tanah', 'Indeks Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setAlign('center');
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->setFixedWidth('20px');
            $grid->AddViewColumn($column);
            //
            // View column for h_dasar field
            //
            $column = new NumberViewColumn('h_dasar', 'h_dasar', 'Harga Dasar', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for harga_kelebihan_tanah field
            //
            $column = new NumberViewColumn('harga_kelebihan_tanah', 'harga_kelebihan_tanah', 'Harga Kelebihan Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->setFixedWidth('50px');
            $grid->AddViewColumn($column);
            //
            // View column for harga_jual field
            //
            $column = new NumberViewColumn('harga_jual', 'harga_jual', 'Harga Jual', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('id_proyek', 'id_proyek_nama_proyek', 'Perumahan', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_kavling field
            //
            $column = new TextViewColumn('no_kavling', 'no_kavling', 'Nomor', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Keterangan', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for kategori field
            //
            $column = new TextViewColumn('kategori', 'kategori', 'Kategori', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for lb field
            //
            $column = new NumberViewColumn('lb', 'lb', 'Bangunan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for lt field
            //
            $column = new NumberViewColumn('lt', 'lt', 'Kavling', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for hj_bangunan field
            //
            $column = new NumberViewColumn('hj_bangunan', 'hj_bangunan', 'Bangunan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for harga_tanah field
            //
            $column = new NumberViewColumn('harga_tanah', 'harga_tanah', 'Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for indeks_tanah field
            //
            $column = new NumberViewColumn('indeks_tanah', 'indeks_tanah', 'Indeks Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for h_dasar field
            //
            $column = new NumberViewColumn('h_dasar', 'h_dasar', 'Harga Dasar', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for harga_kelebihan_tanah field
            //
            $column = new NumberViewColumn('harga_kelebihan_tanah', 'harga_kelebihan_tanah', 'Harga Kelebihan Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for harga_jual field
            //
            $column = new NumberViewColumn('harga_jual', 'harga_jual', 'Harga Jual', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for id_proyek field
            //
            $editor = new DynamicCombobox('id_proyek_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Perumahan', 'id_proyek', 'id_proyek_nama_proyek', 'edit_query_pendekatan_harga_jual_id_proyek_search', $editor, $this->dataset, $lookupDataset, 'id', 'nama_proyek', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_kavling field
            //
            $editor = new TextEdit('no_kavling_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Nomor', 'no_kavling', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ket field
            //
            $editor = new TextEdit('ket_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Keterangan', 'ket', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for kategori field
            //
            $editor = new TextEdit('kategori_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Kategori', 'kategori', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for lb field
            //
            $editor = new TextEdit('lb_edit');
            $editColumn = new CustomEditColumn('Bangunan', 'lb', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for lt field
            //
            $editor = new TextEdit('lt_edit');
            $editColumn = new CustomEditColumn('Kavling', 'lt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for hj_bangunan field
            //
            $editor = new TextEdit('hj_bangunan_edit');
            $editColumn = new CustomEditColumn('Bangunan', 'hj_bangunan', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for harga_tanah field
            //
            $editor = new TextEdit('harga_tanah_edit');
            $editColumn = new CustomEditColumn('Tanah', 'harga_tanah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for indeks_tanah field
            //
            $editor = new TextEdit('indeks_tanah_edit');
            $editColumn = new CustomEditColumn('Indeks Tanah', 'indeks_tanah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for h_dasar field
            //
            $editor = new TextEdit('h_dasar_edit');
            $editColumn = new CustomEditColumn('Harga Dasar', 'h_dasar', $editor, $this->dataset);
            $editColumn->SetReadOnly(true);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for harga_kelebihan_tanah field
            //
            $editor = new TextEdit('harga_kelebihan_tanah_edit');
            $editColumn = new CustomEditColumn('Harga Kelebihan Tanah', 'harga_kelebihan_tanah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for harga_jual field
            //
            $editor = new TextEdit('harga_jual_edit');
            $editColumn = new CustomEditColumn('Harga Jual', 'harga_jual', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for id_proyek field
            //
            $editor = new DynamicCombobox('id_proyek_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Perumahan', 'id_proyek', 'id_proyek_nama_proyek', 'multi_edit_query_pendekatan_harga_jual_id_proyek_search', $editor, $this->dataset, $lookupDataset, 'id', 'nama_proyek', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_kavling field
            //
            $editor = new TextEdit('no_kavling_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Nomor', 'no_kavling', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ket field
            //
            $editor = new TextEdit('ket_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Keterangan', 'ket', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for kategori field
            //
            $editor = new TextEdit('kategori_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Kategori', 'kategori', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for lb field
            //
            $editor = new TextEdit('lb_edit');
            $editColumn = new CustomEditColumn('Bangunan', 'lb', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for lt field
            //
            $editor = new TextEdit('lt_edit');
            $editColumn = new CustomEditColumn('Kavling', 'lt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for hj_bangunan field
            //
            $editor = new TextEdit('hj_bangunan_edit');
            $editColumn = new CustomEditColumn('Bangunan', 'hj_bangunan', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for harga_tanah field
            //
            $editor = new TextEdit('harga_tanah_edit');
            $editColumn = new CustomEditColumn('Tanah', 'harga_tanah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for indeks_tanah field
            //
            $editor = new TextEdit('indeks_tanah_edit');
            $editColumn = new CustomEditColumn('Indeks Tanah', 'indeks_tanah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for h_dasar field
            //
            $editor = new TextEdit('h_dasar_edit');
            $editColumn = new CustomEditColumn('Harga Dasar', 'h_dasar', $editor, $this->dataset);
            $editColumn->SetReadOnly(true);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for harga_kelebihan_tanah field
            //
            $editor = new TextEdit('harga_kelebihan_tanah_edit');
            $editColumn = new CustomEditColumn('Harga Kelebihan Tanah', 'harga_kelebihan_tanah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for harga_jual field
            //
            $editor = new TextEdit('harga_jual_edit');
            $editColumn = new CustomEditColumn('Harga Jual', 'harga_jual', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for id_proyek field
            //
            $editor = new DynamicCombobox('id_proyek_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Perumahan', 'id_proyek', 'id_proyek_nama_proyek', 'insert_query_pendekatan_harga_jual_id_proyek_search', $editor, $this->dataset, $lookupDataset, 'id', 'nama_proyek', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_kavling field
            //
            $editor = new TextEdit('no_kavling_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Nomor', 'no_kavling', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ket field
            //
            $editor = new TextEdit('ket_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Keterangan', 'ket', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for kategori field
            //
            $editor = new TextEdit('kategori_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Kategori', 'kategori', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for lb field
            //
            $editor = new TextEdit('lb_edit');
            $editColumn = new CustomEditColumn('Bangunan', 'lb', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for lt field
            //
            $editor = new TextEdit('lt_edit');
            $editColumn = new CustomEditColumn('Kavling', 'lt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for hj_bangunan field
            //
            $editor = new TextEdit('hj_bangunan_edit');
            $editColumn = new CustomEditColumn('Bangunan', 'hj_bangunan', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for harga_tanah field
            //
            $editor = new TextEdit('harga_tanah_edit');
            $editColumn = new CustomEditColumn('Tanah', 'harga_tanah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for indeks_tanah field
            //
            $editor = new TextEdit('indeks_tanah_edit');
            $editColumn = new CustomEditColumn('Indeks Tanah', 'indeks_tanah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for h_dasar field
            //
            $editor = new TextEdit('h_dasar_edit');
            $editColumn = new CustomEditColumn('Harga Dasar', 'h_dasar', $editor, $this->dataset);
            $editColumn->SetReadOnly(true);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for harga_kelebihan_tanah field
            //
            $editor = new TextEdit('harga_kelebihan_tanah_edit');
            $editColumn = new CustomEditColumn('Harga Kelebihan Tanah', 'harga_kelebihan_tanah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for harga_jual field
            //
            $editor = new TextEdit('harga_jual_edit');
            $editColumn = new CustomEditColumn('Harga Jual', 'harga_jual', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('id_proyek', 'id_proyek_nama_proyek', 'Perumahan', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_kavling field
            //
            $column = new TextViewColumn('no_kavling', 'no_kavling', 'Nomor', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Keterangan', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for kategori field
            //
            $column = new TextViewColumn('kategori', 'kategori', 'Kategori', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for lb field
            //
            $column = new NumberViewColumn('lb', 'lb', 'Bangunan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for lt field
            //
            $column = new NumberViewColumn('lt', 'lt', 'Kavling', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for hj_bangunan field
            //
            $column = new NumberViewColumn('hj_bangunan', 'hj_bangunan', 'Bangunan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for harga_tanah field
            //
            $column = new NumberViewColumn('harga_tanah', 'harga_tanah', 'Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for indeks_tanah field
            //
            $column = new NumberViewColumn('indeks_tanah', 'indeks_tanah', 'Indeks Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setAlign('center');
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for h_dasar field
            //
            $column = new NumberViewColumn('h_dasar', 'h_dasar', 'Harga Dasar', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for harga_kelebihan_tanah field
            //
            $column = new NumberViewColumn('harga_kelebihan_tanah', 'harga_kelebihan_tanah', 'Harga Kelebihan Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for harga_jual field
            //
            $column = new NumberViewColumn('harga_jual', 'harga_jual', 'Harga Jual', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('id_proyek', 'id_proyek_nama_proyek', 'Perumahan', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_kavling field
            //
            $column = new TextViewColumn('no_kavling', 'no_kavling', 'Nomor', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Keterangan', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for kategori field
            //
            $column = new TextViewColumn('kategori', 'kategori', 'Kategori', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for lb field
            //
            $column = new NumberViewColumn('lb', 'lb', 'Bangunan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for lt field
            //
            $column = new NumberViewColumn('lt', 'lt', 'Kavling', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for hj_bangunan field
            //
            $column = new NumberViewColumn('hj_bangunan', 'hj_bangunan', 'Bangunan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for harga_tanah field
            //
            $column = new NumberViewColumn('harga_tanah', 'harga_tanah', 'Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for indeks_tanah field
            //
            $column = new NumberViewColumn('indeks_tanah', 'indeks_tanah', 'Indeks Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setAlign('center');
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for h_dasar field
            //
            $column = new NumberViewColumn('h_dasar', 'h_dasar', 'Harga Dasar', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for harga_kelebihan_tanah field
            //
            $column = new NumberViewColumn('harga_kelebihan_tanah', 'harga_kelebihan_tanah', 'Harga Kelebihan Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for harga_jual field
            //
            $column = new NumberViewColumn('harga_jual', 'harga_jual', 'Harga Jual', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
    
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        
        public function GetEnableModalGridInsert() { return true; }
        public function GetEnableModalSingleRecordView() { return true; }
        
        public function GetEnableModalGridCopy() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $defaultSortedColumns = array();
            $defaultSortedColumns[] = new SortColumn('id', 'ASC');
            $result->setDefaultOrdering($defaultSortedColumns);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(true);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setUseModalMultiEdit(true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            $result->SetTotal('no_kavling', PredefinedAggregate::$Count);
            $result->SetTotal('lb', PredefinedAggregate::$Sum);
            $result->SetTotal('lt', PredefinedAggregate::$Sum);
            $result->SetTotal('h_dasar', PredefinedAggregate::$Sum);
            $result->SetTotal('harga_kelebihan_tanah', PredefinedAggregate::$Sum);
            $result->SetTotal('harga_jual', PredefinedAggregate::$Sum);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->SetHidePageListByDefault(true);
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_query_pendekatan_harga_jual_id_proyek_search', 'id', 'nama_proyek', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_query_pendekatan_harga_jual_id_proyek_search', 'id', 'nama_proyek', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_query_pendekatan_harga_jual_id_proyek_search', 'id', 'nama_proyek', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`proyek`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('luas_taman'),
                    new IntegerField('lt_mushola'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status')
                )
            );
            $lookupDataset->setOrderByField('nama_proyek', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_query_pendekatan_harga_jual_id_proyek_search', 'id', 'nama_proyek', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
            $columnGroup->add(new ViewColumnGroup('Kavling',
                            array(
                                $columns['id_proyek'],
                                $columns['no_kavling'],
                                $columns['ket'],
                                $columns['kategori']
                                
                            )
                        ));
                        $columnGroup->add(new ViewColumnGroup('Luas',
                            array(
                                $columns['lb'],
                                $columns['lt']
                                
                            )
                        ));
                        $columnGroup->add(new ViewColumnGroup('Harga Jual',
                            array(
                                $columns['hj_bangunan'],
                                $columns['harga_tanah']
                                
                            )
                        ));
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }

    SetUpUserAuthorization();

    try
    {
        $Page = new query_pendekatan_harga_jualPage("query_pendekatan_harga_jual", "query_pendekatan_harga_jual.php", GetCurrentUserPermissionsForPage("query_pendekatan_harga_jual"), 'UTF-8');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("query_pendekatan_harga_jual"));
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e);
    }
	
