<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/mysql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class query_proyekPage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Proyek');
            $this->SetMenuLabel('Proyek');
    
            $this->dataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`query_proyek`');
            $this->dataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new StringField('nama_proyek'),
                    new StringField('lokasi'),
                    new IntegerField('total_lt'),
                    new IntegerField('luas_jalan'),
                    new IntegerField('pc_jln'),
                    new IntegerField('luas_taman'),
                    new IntegerField('pc_tmn'),
                    new IntegerField('lt_mushola'),
                    new IntegerField('pc_msl'),
                    new DateField('tgl_mulai'),
                    new IntegerField('tgt_selesai_proyek'),
                    new DateField('tanggal_selesai'),
                    new IntegerField('bgt_1lt_rs'),
                    new IntegerField('bgt_1lt_rk'),
                    new IntegerField('bgt_2lt_rk'),
                    new IntegerField('hg_m2_tanah'),
                    new StringField('ket'),
                    new StringField('status'),
                    new IntegerField('ls_tot_kav'),
                    new IntegerField('pc_kav'),
                    new IntegerField('ls_tot_bgn'),
                    new IntegerField('tot_ls_kav_komersil'),
                    new IntegerField('tot_ls_kav_sub_plus'),
                    new IntegerField('tot_ls_kav_subsidi'),
                    new IntegerField('koef_db')
                )
            );
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id', 'id', 'Id'),
                new FilterColumn($this->dataset, 'nama_proyek', 'nama_proyek', 'Nama'),
                new FilterColumn($this->dataset, 'lokasi', 'lokasi', 'Lokasi'),
                new FilterColumn($this->dataset, 'total_lt', 'total_lt', 'Luas Tanah'),
                new FilterColumn($this->dataset, 'ls_tot_kav', 'ls_tot_kav', 'Luas Kavling (m2)'),
                new FilterColumn($this->dataset, 'pc_kav', 'pc_kav', '% Kavling'),
                new FilterColumn($this->dataset, 'luas_jalan', 'luas_jalan', 'Luas Jalan (m2)'),
                new FilterColumn($this->dataset, 'pc_jln', 'pc_jln', '% Jalan'),
                new FilterColumn($this->dataset, 'luas_taman', 'luas_taman', 'Luas Taman (m2'),
                new FilterColumn($this->dataset, 'pc_tmn', 'pc_tmn', '% Taman'),
                new FilterColumn($this->dataset, 'lt_mushola', 'lt_mushola', 'Luas Mushola (m2)'),
                new FilterColumn($this->dataset, 'pc_msl', 'pc_msl', '% Mushola'),
                new FilterColumn($this->dataset, 'tgl_mulai', 'tgl_mulai', 'Tgl Mulai Proyek'),
                new FilterColumn($this->dataset, 'tgt_selesai_proyek', 'tgt_selesai_proyek', 'Target Selesai (Bln)'),
                new FilterColumn($this->dataset, 'tanggal_selesai', 'tanggal_selesai', 'Tanggal Selesai Proyek'),
                new FilterColumn($this->dataset, 'bgt_1lt_rs', 'bgt_1lt_rs', '1_lt_RS'),
                new FilterColumn($this->dataset, 'bgt_1lt_rk', 'bgt_1lt_rk', '1_lt_RK'),
                new FilterColumn($this->dataset, 'bgt_2lt_rk', 'bgt_2lt_rk', '2_lt_RK'),
                new FilterColumn($this->dataset, 'hg_m2_tanah', 'hg_m2_tanah', 'Harga Tanah(m2)'),
                new FilterColumn($this->dataset, 'koef_db', 'koef_db', 'Koef Dasar_Bgn'),
                new FilterColumn($this->dataset, 'ket', 'ket', 'Keterangan'),
                new FilterColumn($this->dataset, 'status', 'status', 'Status'),
                new FilterColumn($this->dataset, 'ls_tot_bgn', 'ls_tot_bgn', 'Total'),
                new FilterColumn($this->dataset, 'tot_ls_kav_komersil', 'tot_ls_kav_komersil', 'RM Komersil'),
                new FilterColumn($this->dataset, 'tot_ls_kav_sub_plus', 'tot_ls_kav_sub_plus', 'RM Subsidi+'),
                new FilterColumn($this->dataset, 'tot_ls_kav_subsidi', 'tot_ls_kav_subsidi', 'RM Subsidi')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['nama_proyek'])
                ->addColumn($columns['lokasi'])
                ->addColumn($columns['total_lt'])
                ->addColumn($columns['ls_tot_kav'])
                ->addColumn($columns['pc_kav'])
                ->addColumn($columns['luas_jalan'])
                ->addColumn($columns['pc_jln'])
                ->addColumn($columns['luas_taman'])
                ->addColumn($columns['pc_tmn'])
                ->addColumn($columns['lt_mushola'])
                ->addColumn($columns['pc_msl'])
                ->addColumn($columns['tgl_mulai'])
                ->addColumn($columns['tgt_selesai_proyek'])
                ->addColumn($columns['tanggal_selesai'])
                ->addColumn($columns['bgt_1lt_rs'])
                ->addColumn($columns['bgt_1lt_rk'])
                ->addColumn($columns['bgt_2lt_rk'])
                ->addColumn($columns['hg_m2_tanah'])
                ->addColumn($columns['koef_db'])
                ->addColumn($columns['ket'])
                ->addColumn($columns['status'])
                ->addColumn($columns['ls_tot_bgn'])
                ->addColumn($columns['tot_ls_kav_komersil'])
                ->addColumn($columns['tot_ls_kav_sub_plus'])
                ->addColumn($columns['tot_ls_kav_subsidi']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('tgl_mulai')
                ->setOptionsFor('tanggal_selesai');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('nama_proyek_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['nama_proyek'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('lokasi_edit');
            $main_editor->SetMaxLength(100);
            
            $filterBuilder->addColumn(
                $columns['lokasi'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('total_lt_edit');
            
            $filterBuilder->addColumn(
                $columns['total_lt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ls_tot_kav_edit');
            
            $filterBuilder->addColumn(
                $columns['ls_tot_kav'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('pc_kav_edit');
            
            $filterBuilder->addColumn(
                $columns['pc_kav'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('luas_jalan_edit');
            
            $filterBuilder->addColumn(
                $columns['luas_jalan'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('pc_jln_edit');
            
            $filterBuilder->addColumn(
                $columns['pc_jln'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('luas_taman_edit');
            
            $filterBuilder->addColumn(
                $columns['luas_taman'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('pc_tmn_edit');
            
            $filterBuilder->addColumn(
                $columns['pc_tmn'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('lt_mushola_edit');
            
            $filterBuilder->addColumn(
                $columns['lt_mushola'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('pc_msl_edit');
            
            $filterBuilder->addColumn(
                $columns['pc_msl'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('tgl_mulai_edit', false, 'd-m-Y');
            
            $filterBuilder->addColumn(
                $columns['tgl_mulai'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('tgt_selesai_proyek_edit');
            
            $filterBuilder->addColumn(
                $columns['tgt_selesai_proyek'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('tanggal_selesai_edit', false, 'd-m-Y');
            
            $filterBuilder->addColumn(
                $columns['tanggal_selesai'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('bgt_1lt_rs_edit');
            
            $filterBuilder->addColumn(
                $columns['bgt_1lt_rs'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('bgt_1lt_rk_edit');
            
            $filterBuilder->addColumn(
                $columns['bgt_1lt_rk'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('bgt_2lt_rk_edit');
            
            $filterBuilder->addColumn(
                $columns['bgt_2lt_rk'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('hg_m2_tanah_edit');
            
            $filterBuilder->addColumn(
                $columns['hg_m2_tanah'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('koef_db_edit');
            
            $filterBuilder->addColumn(
                $columns['koef_db'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ket_edit');
            $main_editor->SetMaxLength(100);
            
            $filterBuilder->addColumn(
                $columns['ket'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('status_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['status'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ls_tot_bgn_edit');
            
            $filterBuilder->addColumn(
                $columns['ls_tot_bgn'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('tot_ls_kav_komersil_edit');
            
            $filterBuilder->addColumn(
                $columns['tot_ls_kav_komersil'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('tot_ls_kav_sub_plus_edit');
            
            $filterBuilder->addColumn(
                $columns['tot_ls_kav_sub_plus'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('tot_ls_kav_subsidi_edit');
            
            $filterBuilder->addColumn(
                $columns['tot_ls_kav_subsidi'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant()) {
            
                $operation = new AjaxOperation(OPERATION_VIEW,
                    $this->GetLocalizerCaptions()->GetMessageString('View'),
                    $this->GetLocalizerCaptions()->GetMessageString('View'), $this->dataset,
                    $this->GetModalGridViewHandler(), $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new AjaxOperation(OPERATION_EDIT,
                    $this->GetLocalizerCaptions()->GetMessageString('Edit'),
                    $this->GetLocalizerCaptions()->GetMessageString('Edit'), $this->dataset,
                    $this->GetGridEditHandler(), $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new AjaxOperation(OPERATION_COPY,
                    $this->GetLocalizerCaptions()->GetMessageString('Copy'),
                    $this->GetLocalizerCaptions()->GetMessageString('Copy'), $this->dataset,
                    $this->GetModalGridCopyHandler(), $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('nama_proyek', 'nama_proyek', 'Nama', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for lokasi field
            //
            $column = new TextViewColumn('lokasi', 'lokasi', 'Lokasi', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for total_lt field
            //
            $column = new NumberViewColumn('total_lt', 'total_lt', 'Luas Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for ls_tot_kav field
            //
            $column = new NumberViewColumn('ls_tot_kav', 'ls_tot_kav', 'Luas Kavling (m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for pc_kav field
            //
            $column = new PercentViewColumn('pc_kav', 'pc_kav', '% Kavling', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for luas_jalan field
            //
            $column = new NumberViewColumn('luas_jalan', 'luas_jalan', 'Luas Jalan (m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for pc_jln field
            //
            $column = new PercentViewColumn('pc_jln', 'pc_jln', '% Jalan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for luas_taman field
            //
            $column = new NumberViewColumn('luas_taman', 'luas_taman', 'Luas Taman (m2', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for pc_tmn field
            //
            $column = new PercentViewColumn('pc_tmn', 'pc_tmn', '% Taman', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for lt_mushola field
            //
            $column = new NumberViewColumn('lt_mushola', 'lt_mushola', 'Luas Mushola (m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for pc_msl field
            //
            $column = new PercentViewColumn('pc_msl', 'pc_msl', '% Mushola', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator('.');
            $column->setDecimalSeparator(',');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for tgl_mulai field
            //
            $column = new DateTimeViewColumn('tgl_mulai', 'tgl_mulai', 'Tgl Mulai Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for tgt_selesai_proyek field
            //
            $column = new NumberViewColumn('tgt_selesai_proyek', 'tgt_selesai_proyek', 'Target Selesai (Bln)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for tanggal_selesai field
            //
            $column = new DateTimeViewColumn('tanggal_selesai', 'tanggal_selesai', 'Tanggal Selesai Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for bgt_1lt_rs field
            //
            $column = new NumberViewColumn('bgt_1lt_rs', 'bgt_1lt_rs', '1_lt_RS', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for bgt_1lt_rk field
            //
            $column = new NumberViewColumn('bgt_1lt_rk', 'bgt_1lt_rk', '1_lt_RK', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->setFixedWidth('25px');
            $grid->AddViewColumn($column);
            //
            // View column for bgt_2lt_rk field
            //
            $column = new NumberViewColumn('bgt_2lt_rk', 'bgt_2lt_rk', '2_lt_RK', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->setFixedWidth('25px');
            $grid->AddViewColumn($column);
            //
            // View column for hg_m2_tanah field
            //
            $column = new NumberViewColumn('hg_m2_tanah', 'hg_m2_tanah', 'Harga Tanah(m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for koef_db field
            //
            $column = new PercentViewColumn('koef_db', 'koef_db', 'Koef Dasar_Bgn', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Keterangan', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for status field
            //
            $column = new TextViewColumn('status', 'status', 'Status', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for ls_tot_bgn field
            //
            $column = new NumberViewColumn('ls_tot_bgn', 'ls_tot_bgn', 'Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for tot_ls_kav_komersil field
            //
            $column = new NumberViewColumn('tot_ls_kav_komersil', 'tot_ls_kav_komersil', 'RM Komersil', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for tot_ls_kav_sub_plus field
            //
            $column = new NumberViewColumn('tot_ls_kav_sub_plus', 'tot_ls_kav_sub_plus', 'RM Subsidi+', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for tot_ls_kav_subsidi field
            //
            $column = new NumberViewColumn('tot_ls_kav_subsidi', 'tot_ls_kav_subsidi', 'RM Subsidi', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('nama_proyek', 'nama_proyek', 'Nama', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for lokasi field
            //
            $column = new TextViewColumn('lokasi', 'lokasi', 'Lokasi', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for total_lt field
            //
            $column = new NumberViewColumn('total_lt', 'total_lt', 'Luas Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ls_tot_kav field
            //
            $column = new NumberViewColumn('ls_tot_kav', 'ls_tot_kav', 'Luas Kavling (m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for pc_kav field
            //
            $column = new PercentViewColumn('pc_kav', 'pc_kav', '% Kavling', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for luas_jalan field
            //
            $column = new NumberViewColumn('luas_jalan', 'luas_jalan', 'Luas Jalan (m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for pc_jln field
            //
            $column = new PercentViewColumn('pc_jln', 'pc_jln', '% Jalan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for luas_taman field
            //
            $column = new NumberViewColumn('luas_taman', 'luas_taman', 'Luas Taman (m2', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for pc_tmn field
            //
            $column = new PercentViewColumn('pc_tmn', 'pc_tmn', '% Taman', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for lt_mushola field
            //
            $column = new NumberViewColumn('lt_mushola', 'lt_mushola', 'Luas Mushola (m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for pc_msl field
            //
            $column = new PercentViewColumn('pc_msl', 'pc_msl', '% Mushola', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator('.');
            $column->setDecimalSeparator(',');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for tgl_mulai field
            //
            $column = new DateTimeViewColumn('tgl_mulai', 'tgl_mulai', 'Tgl Mulai Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for tgt_selesai_proyek field
            //
            $column = new NumberViewColumn('tgt_selesai_proyek', 'tgt_selesai_proyek', 'Target Selesai (Bln)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for tanggal_selesai field
            //
            $column = new DateTimeViewColumn('tanggal_selesai', 'tanggal_selesai', 'Tanggal Selesai Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for bgt_1lt_rs field
            //
            $column = new NumberViewColumn('bgt_1lt_rs', 'bgt_1lt_rs', '1_lt_RS', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for bgt_1lt_rk field
            //
            $column = new NumberViewColumn('bgt_1lt_rk', 'bgt_1lt_rk', '1_lt_RK', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for bgt_2lt_rk field
            //
            $column = new NumberViewColumn('bgt_2lt_rk', 'bgt_2lt_rk', '2_lt_RK', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for hg_m2_tanah field
            //
            $column = new NumberViewColumn('hg_m2_tanah', 'hg_m2_tanah', 'Harga Tanah(m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for koef_db field
            //
            $column = new PercentViewColumn('koef_db', 'koef_db', 'Koef Dasar_Bgn', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Keterangan', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for status field
            //
            $column = new TextViewColumn('status', 'status', 'Status', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ls_tot_bgn field
            //
            $column = new NumberViewColumn('ls_tot_bgn', 'ls_tot_bgn', 'Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for tot_ls_kav_komersil field
            //
            $column = new NumberViewColumn('tot_ls_kav_komersil', 'tot_ls_kav_komersil', 'RM Komersil', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for tot_ls_kav_sub_plus field
            //
            $column = new NumberViewColumn('tot_ls_kav_sub_plus', 'tot_ls_kav_sub_plus', 'RM Subsidi+', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for tot_ls_kav_subsidi field
            //
            $column = new NumberViewColumn('tot_ls_kav_subsidi', 'tot_ls_kav_subsidi', 'RM Subsidi', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for nama_proyek field
            //
            $editor = new TextEdit('nama_proyek_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Nama', 'nama_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for lokasi field
            //
            $editor = new TextEdit('lokasi_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Lokasi', 'lokasi', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for total_lt field
            //
            $editor = new TextEdit('total_lt_edit');
            $editColumn = new CustomEditColumn('Luas Tanah', 'total_lt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ls_tot_kav field
            //
            $editor = new TextEdit('ls_tot_kav_edit');
            $editColumn = new CustomEditColumn('Luas Kavling (m2)', 'ls_tot_kav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for pc_kav field
            //
            $editor = new TextEdit('pc_kav_edit');
            $editColumn = new CustomEditColumn('% Kavling', 'pc_kav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for luas_jalan field
            //
            $editor = new TextEdit('luas_jalan_edit');
            $editColumn = new CustomEditColumn('Luas Jalan (m2)', 'luas_jalan', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for pc_jln field
            //
            $editor = new TextEdit('pc_jln_edit');
            $editColumn = new CustomEditColumn('% Jalan', 'pc_jln', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for luas_taman field
            //
            $editor = new TextEdit('luas_taman_edit');
            $editColumn = new CustomEditColumn('Luas Taman (m2', 'luas_taman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for pc_tmn field
            //
            $editor = new TextEdit('pc_tmn_edit');
            $editColumn = new CustomEditColumn('% Taman', 'pc_tmn', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for lt_mushola field
            //
            $editor = new TextEdit('lt_mushola_edit');
            $editColumn = new CustomEditColumn('Luas Mushola (m2)', 'lt_mushola', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for pc_msl field
            //
            $editor = new TextEdit('pc_msl_edit');
            $editColumn = new CustomEditColumn('% Mushola', 'pc_msl', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for tgl_mulai field
            //
            $editor = new DateTimeEdit('tgl_mulai_edit', false, 'd-m-Y');
            $editColumn = new CustomEditColumn('Tgl Mulai Proyek', 'tgl_mulai', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for tgt_selesai_proyek field
            //
            $editor = new TextEdit('tgt_selesai_proyek_edit');
            $editColumn = new CustomEditColumn('Target Selesai (Bln)', 'tgt_selesai_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for tanggal_selesai field
            //
            $editor = new DateTimeEdit('tanggal_selesai_edit', false, 'd-m-Y');
            $editColumn = new CustomEditColumn('Tanggal Selesai Proyek', 'tanggal_selesai', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for bgt_1lt_rs field
            //
            $editor = new TextEdit('bgt_1lt_rs_edit');
            $editColumn = new CustomEditColumn('1_lt_RS', 'bgt_1lt_rs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for bgt_1lt_rk field
            //
            $editor = new TextEdit('bgt_1lt_rk_edit');
            $editColumn = new CustomEditColumn('1_lt_RK', 'bgt_1lt_rk', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for bgt_2lt_rk field
            //
            $editor = new TextEdit('bgt_2lt_rk_edit');
            $editColumn = new CustomEditColumn('2_lt_RK', 'bgt_2lt_rk', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for hg_m2_tanah field
            //
            $editor = new TextEdit('hg_m2_tanah_edit');
            $editColumn = new CustomEditColumn('Harga Tanah(m2)', 'hg_m2_tanah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for koef_db field
            //
            $editor = new TextEdit('koef_db_edit');
            $editColumn = new CustomEditColumn('Koef Dasar_Bgn', 'koef_db', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ket field
            //
            $editor = new TextEdit('ket_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Keterangan', 'ket', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for status field
            //
            $editor = new TextEdit('status_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Status', 'status', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ls_tot_bgn field
            //
            $editor = new TextEdit('ls_tot_bgn_edit');
            $editColumn = new CustomEditColumn('Total', 'ls_tot_bgn', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for tot_ls_kav_komersil field
            //
            $editor = new TextEdit('tot_ls_kav_komersil_edit');
            $editColumn = new CustomEditColumn('RM Komersil', 'tot_ls_kav_komersil', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for tot_ls_kav_sub_plus field
            //
            $editor = new TextEdit('tot_ls_kav_sub_plus_edit');
            $editColumn = new CustomEditColumn('RM Subsidi+', 'tot_ls_kav_sub_plus', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for tot_ls_kav_subsidi field
            //
            $editor = new TextEdit('tot_ls_kav_subsidi_edit');
            $editColumn = new CustomEditColumn('RM Subsidi', 'tot_ls_kav_subsidi', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for nama_proyek field
            //
            $editor = new TextEdit('nama_proyek_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Nama', 'nama_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for lokasi field
            //
            $editor = new TextEdit('lokasi_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Lokasi', 'lokasi', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for total_lt field
            //
            $editor = new TextEdit('total_lt_edit');
            $editColumn = new CustomEditColumn('Luas Tanah', 'total_lt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ls_tot_kav field
            //
            $editor = new TextEdit('ls_tot_kav_edit');
            $editColumn = new CustomEditColumn('Luas Kavling (m2)', 'ls_tot_kav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for pc_kav field
            //
            $editor = new TextEdit('pc_kav_edit');
            $editColumn = new CustomEditColumn('% Kavling', 'pc_kav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for luas_jalan field
            //
            $editor = new TextEdit('luas_jalan_edit');
            $editColumn = new CustomEditColumn('Luas Jalan (m2)', 'luas_jalan', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for pc_jln field
            //
            $editor = new TextEdit('pc_jln_edit');
            $editColumn = new CustomEditColumn('% Jalan', 'pc_jln', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for luas_taman field
            //
            $editor = new TextEdit('luas_taman_edit');
            $editColumn = new CustomEditColumn('Luas Taman (m2', 'luas_taman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for pc_tmn field
            //
            $editor = new TextEdit('pc_tmn_edit');
            $editColumn = new CustomEditColumn('% Taman', 'pc_tmn', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for lt_mushola field
            //
            $editor = new TextEdit('lt_mushola_edit');
            $editColumn = new CustomEditColumn('Luas Mushola (m2)', 'lt_mushola', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for pc_msl field
            //
            $editor = new TextEdit('pc_msl_edit');
            $editColumn = new CustomEditColumn('% Mushola', 'pc_msl', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for tgl_mulai field
            //
            $editor = new DateTimeEdit('tgl_mulai_edit', false, 'd-m-Y');
            $editColumn = new CustomEditColumn('Tgl Mulai Proyek', 'tgl_mulai', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for tgt_selesai_proyek field
            //
            $editor = new TextEdit('tgt_selesai_proyek_edit');
            $editColumn = new CustomEditColumn('Target Selesai (Bln)', 'tgt_selesai_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for tanggal_selesai field
            //
            $editor = new DateTimeEdit('tanggal_selesai_edit', false, 'd-m-Y');
            $editColumn = new CustomEditColumn('Tanggal Selesai Proyek', 'tanggal_selesai', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for bgt_1lt_rs field
            //
            $editor = new TextEdit('bgt_1lt_rs_edit');
            $editColumn = new CustomEditColumn('1_lt_RS', 'bgt_1lt_rs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for bgt_1lt_rk field
            //
            $editor = new TextEdit('bgt_1lt_rk_edit');
            $editColumn = new CustomEditColumn('1_lt_RK', 'bgt_1lt_rk', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for bgt_2lt_rk field
            //
            $editor = new TextEdit('bgt_2lt_rk_edit');
            $editColumn = new CustomEditColumn('2_lt_RK', 'bgt_2lt_rk', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for hg_m2_tanah field
            //
            $editor = new TextEdit('hg_m2_tanah_edit');
            $editColumn = new CustomEditColumn('Harga Tanah(m2)', 'hg_m2_tanah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for koef_db field
            //
            $editor = new TextEdit('koef_db_edit');
            $editColumn = new CustomEditColumn('Koef Dasar_Bgn', 'koef_db', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ket field
            //
            $editor = new TextEdit('ket_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Keterangan', 'ket', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for status field
            //
            $editor = new TextEdit('status_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Status', 'status', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ls_tot_bgn field
            //
            $editor = new TextEdit('ls_tot_bgn_edit');
            $editColumn = new CustomEditColumn('Total', 'ls_tot_bgn', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for tot_ls_kav_komersil field
            //
            $editor = new TextEdit('tot_ls_kav_komersil_edit');
            $editColumn = new CustomEditColumn('RM Komersil', 'tot_ls_kav_komersil', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for tot_ls_kav_sub_plus field
            //
            $editor = new TextEdit('tot_ls_kav_sub_plus_edit');
            $editColumn = new CustomEditColumn('RM Subsidi+', 'tot_ls_kav_sub_plus', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for tot_ls_kav_subsidi field
            //
            $editor = new TextEdit('tot_ls_kav_subsidi_edit');
            $editColumn = new CustomEditColumn('RM Subsidi', 'tot_ls_kav_subsidi', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for nama_proyek field
            //
            $editor = new TextEdit('nama_proyek_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Nama Proyek', 'nama_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for lokasi field
            //
            $editor = new TextEdit('lokasi_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Lokasi Proyek', 'lokasi', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for total_lt field
            //
            $editor = new TextEdit('total_lt_edit');
            $editColumn = new CustomEditColumn('Luas Tanah', 'total_lt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ls_tot_kav field
            //
            $editor = new TextEdit('ls_tot_kav_edit');
            $editColumn = new CustomEditColumn('Luas Kavling (m2)', 'ls_tot_kav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for pc_kav field
            //
            $editor = new TextEdit('pc_kav_edit');
            $editColumn = new CustomEditColumn('% Kavling', 'pc_kav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for luas_jalan field
            //
            $editor = new TextEdit('luas_jalan_edit');
            $editColumn = new CustomEditColumn('Luas Jalan (m2)', 'luas_jalan', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for pc_jln field
            //
            $editor = new TextEdit('pc_jln_edit');
            $editColumn = new CustomEditColumn('% Jalan', 'pc_jln', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for luas_taman field
            //
            $editor = new TextEdit('luas_taman_edit');
            $editColumn = new CustomEditColumn('Luas Taman (m2', 'luas_taman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for pc_tmn field
            //
            $editor = new TextEdit('pc_tmn_edit');
            $editColumn = new CustomEditColumn('% Taman', 'pc_tmn', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for lt_mushola field
            //
            $editor = new TextEdit('lt_mushola_edit');
            $editColumn = new CustomEditColumn('Luas Mushola (m2)', 'lt_mushola', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for pc_msl field
            //
            $editor = new TextEdit('pc_msl_edit');
            $editColumn = new CustomEditColumn('% Mushola', 'pc_msl', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for tgl_mulai field
            //
            $editor = new DateTimeEdit('tgl_mulai_edit', false, 'd-m-Y');
            $editColumn = new CustomEditColumn('Tgl Mulai Proyek', 'tgl_mulai', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for tgt_selesai_proyek field
            //
            $editor = new TextEdit('tgt_selesai_proyek_edit');
            $editColumn = new CustomEditColumn('Target Selesai (Bln)', 'tgt_selesai_proyek', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for tanggal_selesai field
            //
            $editor = new DateTimeEdit('tanggal_selesai_edit', false, 'd-m-Y');
            $editColumn = new CustomEditColumn('Tanggal Selesai Proyek', 'tanggal_selesai', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for bgt_1lt_rs field
            //
            $editor = new TextEdit('bgt_1lt_rs_edit');
            $editColumn = new CustomEditColumn('Budget Bgn 1 lt RS', 'bgt_1lt_rs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for bgt_1lt_rk field
            //
            $editor = new TextEdit('bgt_1lt_rk_edit');
            $editColumn = new CustomEditColumn('Budget Bgn 1 lt RK', 'bgt_1lt_rk', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for bgt_2lt_rk field
            //
            $editor = new TextEdit('bgt_2lt_rk_edit');
            $editColumn = new CustomEditColumn('Budget Bgn 2 lt RK', 'bgt_2lt_rk', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for hg_m2_tanah field
            //
            $editor = new TextEdit('hg_m2_tanah_edit');
            $editColumn = new CustomEditColumn('Harga Tanah(m2)', 'hg_m2_tanah', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for koef_db field
            //
            $editor = new TextEdit('koef_db_edit');
            $editColumn = new CustomEditColumn('Koef Dasar_Bgn', 'koef_db', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ket field
            //
            $editor = new TextEdit('ket_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Keterangan', 'ket', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for status field
            //
            $editor = new TextEdit('status_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Status', 'status', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ls_tot_bgn field
            //
            $editor = new TextEdit('ls_tot_bgn_edit');
            $editColumn = new CustomEditColumn('Luas Total Bgn', 'ls_tot_bgn', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for tot_ls_kav_komersil field
            //
            $editor = new TextEdit('tot_ls_kav_komersil_edit');
            $editColumn = new CustomEditColumn('Luas RM Komersil', 'tot_ls_kav_komersil', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for tot_ls_kav_sub_plus field
            //
            $editor = new TextEdit('tot_ls_kav_sub_plus_edit');
            $editColumn = new CustomEditColumn('Luas RM Subsidi+', 'tot_ls_kav_sub_plus', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for tot_ls_kav_subsidi field
            //
            $editor = new TextEdit('tot_ls_kav_subsidi_edit');
            $editColumn = new CustomEditColumn('Luas RM Subsidi', 'tot_ls_kav_subsidi', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('nama_proyek', 'nama_proyek', 'Nama', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for lokasi field
            //
            $column = new TextViewColumn('lokasi', 'lokasi', 'Lokasi', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for total_lt field
            //
            $column = new NumberViewColumn('total_lt', 'total_lt', 'Luas Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for ls_tot_kav field
            //
            $column = new NumberViewColumn('ls_tot_kav', 'ls_tot_kav', 'Luas Kavling (m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for pc_kav field
            //
            $column = new PercentViewColumn('pc_kav', 'pc_kav', '% Kavling', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for luas_jalan field
            //
            $column = new NumberViewColumn('luas_jalan', 'luas_jalan', 'Luas Jalan (m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for pc_jln field
            //
            $column = new PercentViewColumn('pc_jln', 'pc_jln', '% Jalan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for luas_taman field
            //
            $column = new NumberViewColumn('luas_taman', 'luas_taman', 'Luas Taman (m2', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for pc_tmn field
            //
            $column = new PercentViewColumn('pc_tmn', 'pc_tmn', '% Taman', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for lt_mushola field
            //
            $column = new NumberViewColumn('lt_mushola', 'lt_mushola', 'Luas Mushola (m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for pc_msl field
            //
            $column = new PercentViewColumn('pc_msl', 'pc_msl', '% Mushola', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator('.');
            $column->setDecimalSeparator(',');
            $grid->AddPrintColumn($column);
            
            //
            // View column for tgl_mulai field
            //
            $column = new DateTimeViewColumn('tgl_mulai', 'tgl_mulai', 'Tgl Mulai Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
            
            //
            // View column for tgt_selesai_proyek field
            //
            $column = new NumberViewColumn('tgt_selesai_proyek', 'tgt_selesai_proyek', 'Target Selesai (Bln)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for tanggal_selesai field
            //
            $column = new DateTimeViewColumn('tanggal_selesai', 'tanggal_selesai', 'Tanggal Selesai Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
            
            //
            // View column for bgt_1lt_rs field
            //
            $column = new NumberViewColumn('bgt_1lt_rs', 'bgt_1lt_rs', '1_lt_RS', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for bgt_1lt_rk field
            //
            $column = new NumberViewColumn('bgt_1lt_rk', 'bgt_1lt_rk', '1_lt_RK', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for bgt_2lt_rk field
            //
            $column = new NumberViewColumn('bgt_2lt_rk', 'bgt_2lt_rk', '2_lt_RK', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for hg_m2_tanah field
            //
            $column = new NumberViewColumn('hg_m2_tanah', 'hg_m2_tanah', 'Harga Tanah(m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for koef_db field
            //
            $column = new PercentViewColumn('koef_db', 'koef_db', 'Koef Dasar_Bgn', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Keterangan', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for status field
            //
            $column = new TextViewColumn('status', 'status', 'Status', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ls_tot_bgn field
            //
            $column = new NumberViewColumn('ls_tot_bgn', 'ls_tot_bgn', 'Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for tot_ls_kav_komersil field
            //
            $column = new NumberViewColumn('tot_ls_kav_komersil', 'tot_ls_kav_komersil', 'RM Komersil', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for tot_ls_kav_sub_plus field
            //
            $column = new NumberViewColumn('tot_ls_kav_sub_plus', 'tot_ls_kav_sub_plus', 'RM Subsidi+', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for tot_ls_kav_subsidi field
            //
            $column = new NumberViewColumn('tot_ls_kav_subsidi', 'tot_ls_kav_subsidi', 'RM Subsidi', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for nama_proyek field
            //
            $column = new TextViewColumn('nama_proyek', 'nama_proyek', 'Nama', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for lokasi field
            //
            $column = new TextViewColumn('lokasi', 'lokasi', 'Lokasi', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for total_lt field
            //
            $column = new NumberViewColumn('total_lt', 'total_lt', 'Luas Tanah', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for ls_tot_kav field
            //
            $column = new NumberViewColumn('ls_tot_kav', 'ls_tot_kav', 'Luas Kavling (m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for pc_kav field
            //
            $column = new PercentViewColumn('pc_kav', 'pc_kav', '% Kavling', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for luas_jalan field
            //
            $column = new NumberViewColumn('luas_jalan', 'luas_jalan', 'Luas Jalan (m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for pc_jln field
            //
            $column = new PercentViewColumn('pc_jln', 'pc_jln', '% Jalan', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for luas_taman field
            //
            $column = new NumberViewColumn('luas_taman', 'luas_taman', 'Luas Taman (m2', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for pc_tmn field
            //
            $column = new PercentViewColumn('pc_tmn', 'pc_tmn', '% Taman', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for lt_mushola field
            //
            $column = new NumberViewColumn('lt_mushola', 'lt_mushola', 'Luas Mushola (m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for pc_msl field
            //
            $column = new PercentViewColumn('pc_msl', 'pc_msl', '% Mushola', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator('.');
            $column->setDecimalSeparator(',');
            $grid->AddExportColumn($column);
            
            //
            // View column for tgl_mulai field
            //
            $column = new DateTimeViewColumn('tgl_mulai', 'tgl_mulai', 'Tgl Mulai Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
            
            //
            // View column for tgt_selesai_proyek field
            //
            $column = new NumberViewColumn('tgt_selesai_proyek', 'tgt_selesai_proyek', 'Target Selesai (Bln)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for tanggal_selesai field
            //
            $column = new DateTimeViewColumn('tanggal_selesai', 'tanggal_selesai', 'Tanggal Selesai Proyek', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
            
            //
            // View column for bgt_1lt_rs field
            //
            $column = new NumberViewColumn('bgt_1lt_rs', 'bgt_1lt_rs', '1_lt_RS', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for bgt_1lt_rk field
            //
            $column = new NumberViewColumn('bgt_1lt_rk', 'bgt_1lt_rk', '1_lt_RK', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for bgt_2lt_rk field
            //
            $column = new NumberViewColumn('bgt_2lt_rk', 'bgt_2lt_rk', '2_lt_RK', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for hg_m2_tanah field
            //
            $column = new NumberViewColumn('hg_m2_tanah', 'hg_m2_tanah', 'Harga Tanah(m2)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for koef_db field
            //
            $column = new PercentViewColumn('koef_db', 'koef_db', 'Koef Dasar_Bgn', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(2);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for ket field
            //
            $column = new TextViewColumn('ket', 'ket', 'Keterangan', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for status field
            //
            $column = new TextViewColumn('status', 'status', 'Status', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ls_tot_bgn field
            //
            $column = new NumberViewColumn('ls_tot_bgn', 'ls_tot_bgn', 'Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for tot_ls_kav_komersil field
            //
            $column = new NumberViewColumn('tot_ls_kav_komersil', 'tot_ls_kav_komersil', 'RM Komersil', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for tot_ls_kav_sub_plus field
            //
            $column = new NumberViewColumn('tot_ls_kav_sub_plus', 'tot_ls_kav_sub_plus', 'RM Subsidi+', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for tot_ls_kav_subsidi field
            //
            $column = new NumberViewColumn('tot_ls_kav_subsidi', 'tot_ls_kav_subsidi', 'RM Subsidi', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
    
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        
        public function GetEnableModalGridInsert() { return true; }
        public function GetEnableModalSingleRecordView() { return true; }
        
        public function GetEnableModalGridCopy() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(true);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setUseModalMultiEdit(true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->SetHidePageListByDefault(true);
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            
            
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
            $columnGroup->add(new ViewColumnGroup('Proyek',
                            array(
                                $columns['nama_proyek'],
                                $columns['lokasi'],
                                $columns['total_lt']
                                
                            )
                        ));
                        
                        $columnGroup->add(new ViewColumnGroup('Kavling',
                            array(
                                $columns['ls_tot_kav'],
                                $columns['pc_kav']
                                
                            )
                        ));
                        
                        $columnGroup->add(new ViewColumnGroup('Jalan',
                            array(
                                $columns['luas_jalan'],
                                $columns['pc_jln']
                                
                            )
                        ));
                        
                        $columnGroup->add(new ViewColumnGroup('Taman',
                            array(
                                $columns['luas_taman'],
                                $columns['pc_tmn']
                                
                            )
                        ));
                        
                        $columnGroup->add(new ViewColumnGroup('Mushola',
                            array(
                                $columns['lt_mushola'],
                                $columns['pc_msl']
                                
                            )
                        ));
                        
                        $columnGroup->add(new ViewColumnGroup('Target Timeline',
                            array(
                                $columns['tgl_mulai'],
                                $columns['tgt_selesai_proyek'],
                                $columns['tanggal_selesai'],
                                $columns['status']
                                
                            )
                        ));
                        
                        $columnGroup->add(new ViewColumnGroup('Budget',
                            array(
                                $columns['bgt_1lt_rs'],
                                $columns['bgt_1lt_rk'],
                                $columns['bgt_2lt_rk']
                                
                            )
                        ));
                        
                        $columnGroup->add(new ViewColumnGroup('Luas Bangunan',
                            array(
                                $columns['ls_tot_bgn'],
                                $columns['tot_ls_kav_komersil'],
                                $columns['tot_ls_kav_sub_plus'],
                                $columns['tot_ls_kav_subsidi']
                                
                            )
                        ));
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }

    SetUpUserAuthorization();

    try
    {
        $Page = new query_proyekPage("query_proyek", "query_proyek.php", GetCurrentUserPermissionsForPage("query_proyek"), 'UTF-8');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("query_proyek"));
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e);
    }
	
